/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.client;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.token.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.LoggerFactory;

public interface HttpClientFactory {
    public static final List<HttpClientFactory> services = new ArrayList(){
        {
            ServiceLoader.load(HttpClientFactory.class).forEach(this::add);
            LoggerFactory.getLogger(HttpClientFactory.class).info("loaded HttpClientFactory service providers: {}", (Object)this);
        }
    };

    public CloseableHttpClient createClient(ClientIdentity var1) throws HttpClientException;

    public static CloseableHttpClient create(ClientIdentity clientIdentity) throws HttpClientException {
        if (services.isEmpty()) {
            throw new ProviderNotFoundException("No HttpClientFactory service could be found in the classpath");
        }
        return services.get(0).createClient(clientIdentity);
    }
}

