/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.mtls;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

class MinimalDERParser {
    private static final String INVALID_LENGTH_ENCODING = "Invalid length encoding";
    private byte[] content;
    private int idx;

    public MinimalDERParser(byte[] content) {
        this.content = content;
    }

    public int getSequence() throws IOException {
        this.ensureTag(48);
        return this.readLength();
    }

    public BigInteger getBigInteger() throws IOException {
        this.ensureTag(2);
        return new BigInteger(this.extractBytes(this.readLength()));
    }

    private byte[] extractBytes(int numBytes) throws IOException {
        this.ensureRemainingSize(numBytes);
        byte[] tmp = new byte[numBytes];
        System.arraycopy(this.content, this.idx, tmp, 0, numBytes);
        this.idx += numBytes;
        return tmp;
    }

    private void ensureRemainingSize(int size) throws IOException {
        this.ensure(size > 0, INVALID_LENGTH_ENCODING);
        if (this.idx + size > this.content.length) {
            throw new EOFException();
        }
    }

    private void ensure(boolean condition, String message) throws IOException {
        if (!condition) {
            throw new IOException(message);
        }
    }

    private int readLength() throws IOException {
        int length = this.nextByte();
        this.ensure(length != 256, INVALID_LENGTH_ENCODING);
        if (length <= 127) {
            return length;
        }
        if ((length -= 128) == 0) {
            return -1;
        }
        this.ensure(length < 4, INVALID_LENGTH_ENCODING);
        int totalLength = 0;
        for (int i = 0; i < length; ++i) {
            this.ensure((totalLength = totalLength * 256 + this.nextByte()) > 0, INVALID_LENGTH_ENCODING);
        }
        return totalLength;
    }

    private void ensureTag(int tag) throws IOException {
        int next = this.nextByte();
        if (next != tag) {
            throw new IOException(String.format("Expected tag 0x%2x but 0x%2x found", tag, next));
        }
    }

    private int nextByte() throws IOException {
        this.ensureRemainingSize(1);
        return this.content[this.idx++] & 0xFF;
    }
}

