/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.mtls;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.MinimalDERParser;
import com.sap.cloud.security.xsuaa.Assertions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextFactory {
    private static final char[] noPassword = "".toCharArray();
    private static final SSLContextFactory instance = new SSLContextFactory();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private SSLContextFactory() {
    }

    public static SSLContextFactory getInstance() {
        return instance;
    }

    public SSLContext create(String x509Certificates, String rsaPrivateKey) throws GeneralSecurityException, IOException {
        Assertions.assertHasText(x509Certificates, "x509Certificate is required");
        Assertions.assertHasText(rsaPrivateKey, "rsaPrivateKey is required");
        return this.create((ClientIdentity)new ClientCertificate(x509Certificates, rsaPrivateKey, null));
    }

    public SSLContext create(ClientIdentity clientIdentity) throws GeneralSecurityException, IOException {
        Assertions.assertNotNull(clientIdentity, "clientIdentity must not be null");
        Assertions.assertHasText(clientIdentity.getCertificate(), "clientIdentity.getCertificate() must not return null");
        Assertions.assertHasText(clientIdentity.getKey(), "clientIdentity.getKey() must not return null");
        KeyStore keystore = this.createKeyStore(clientIdentity);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keystore, noPassword);
        SSLContext sslContext = this.createDefaultSSLContext();
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sslContext;
    }

    public KeyStore createKeyStore(ClientIdentity clientIdentity) throws GeneralSecurityException, IOException {
        Assertions.assertNotNull(clientIdentity, "clientIdentity must not be null");
        Assertions.assertHasText(clientIdentity.getCertificate(), "clientIdentity.getCertificate() must not return null");
        Assertions.assertHasText(clientIdentity.getKey(), "clientIdentity.getKey() must not return null");
        PrivateKey privateKey = this.getPrivateKeyFromString(clientIdentity.getKey());
        Certificate[] certificateChain = this.getCertificatesFromString(clientIdentity.getCertificate());
        return this.initializeKeyStore(privateKey, certificateChain);
    }

    private KeyStore initializeKeyStore(PrivateKey privateKey, Certificate[] certificateChain) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(null);
        int i = 0;
        for (Certificate certificate : certificateChain) {
            keystore.setCertificateEntry("cert-alias-" + i++, certificate);
        }
        keystore.setKeyEntry("key-alias", privateKey, noPassword, certificateChain);
        return keystore;
    }

    private SSLContext createDefaultSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance("TLS");
    }

    private PrivateKey getPrivateKeyFromString(String rsaPrivateKey) throws GeneralSecurityException {
        String privateKeyPEM = rsaPrivateKey;
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privateKeyPEM = privateKeyPEM.replace("-----END RSA PRIVATE KEY-----", "");
        privateKeyPEM = privateKeyPEM.replace("\n", "");
        privateKeyPEM = privateKeyPEM.replace("\\n", "");
        this.logger.debug("privateKeyPem: '{}'", (Object)privateKeyPEM);
        KeySpec keySpec = this.parseDERPrivateKey(Base64.getDecoder().decode(privateKeyPEM));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private Certificate[] getCertificatesFromString(String certificates) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        byte[] certificatesBytes = certificates.replace("\\n", "\n").getBytes();
        Collection<? extends Certificate> certificateList = factory.generateCertificates(new ByteArrayInputStream(certificatesBytes));
        return certificateList.toArray(new Certificate[0]);
    }

    private KeySpec parseDERPrivateKey(byte[] privateKeyDerEncoded) throws GeneralSecurityException {
        RSAPrivateCrtKeySpec keySpec;
        MinimalDERParser parser = new MinimalDERParser(privateKeyDerEncoded);
        try {
            parser.getSequence();
            BigInteger version = parser.getBigInteger();
            if (!version.equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Only version 0 supported for PKCS1 decoding.");
            }
            BigInteger modulus = parser.getBigInteger();
            BigInteger publicExponent = parser.getBigInteger();
            BigInteger privateExponent = parser.getBigInteger();
            BigInteger primeP = parser.getBigInteger();
            BigInteger primeQ = parser.getBigInteger();
            BigInteger primeExponentP = parser.getBigInteger();
            BigInteger primeExponentQ = parser.getBigInteger();
            BigInteger crtCoefficient = parser.getBigInteger();
            keySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Exception during parsing DER encoded private key", e);
        }
        return keySpec;
    }
}

