/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.RequestParameterBuilder;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.http.HttpHeadersFactory;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import com.sap.cloud.security.xsuaa.tokenflows.Cacheable;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuth2TokenService
implements OAuth2TokenService,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOAuth2TokenService.class);
    private final Cache<CacheKey, OAuth2TokenResponse> responseCache;
    private final TokenCacheConfiguration tokenCacheConfiguration;

    public AbstractOAuth2TokenService() {
        this(TokenCacheConfiguration.defaultConfiguration(), Ticker.systemTicker(), false);
    }

    public AbstractOAuth2TokenService(TokenCacheConfiguration tokenCacheConfiguration) {
        this(tokenCacheConfiguration, Ticker.systemTicker(), false);
    }

    AbstractOAuth2TokenService(TokenCacheConfiguration tokenCacheConfiguration, Ticker cacheTicker, boolean sameThreadCache) {
        Assertions.assertNotNull(tokenCacheConfiguration, "cacheConfiguration is required");
        this.tokenCacheConfiguration = tokenCacheConfiguration;
        this.responseCache = this.createResponseCache(cacheTicker, sameThreadCache);
        if (this.isCacheDisabled()) {
            LOGGER.debug("Configured token service with cache disabled");
        } else {
            LOGGER.debug("Configured token service with {}", (Object)tokenCacheConfiguration);
        }
    }

    @Override
    public void clearCache() {
        this.responseCache.invalidateAll();
    }

    @Override
    @Nonnull
    public TokenCacheConfiguration getCacheConfiguration() {
        return this.tokenCacheConfiguration;
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaClientCredentialsGrant(@Nonnull URI tokenEndpointUri, @Nonnull ClientIdentity clientIdentity, @Nullable String zoneId, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters, boolean disableCacheForRequest) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("client_credentials").withClientIdentity(clientIdentity).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        if (zoneId != null) {
            headers.withHeader("X-zid", zoneId);
        }
        return this.getOAuth2TokenResponse(tokenEndpointUri, headers, parameters, subdomain, disableCacheForRequest);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaUserTokenGrant(@Nonnull URI tokenEndpointUri, @Nonnull ClientIdentity clientIdentity, @Nonnull String token, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Assertions.assertNotNull(token, "token is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("user_token").withClientId(clientIdentity.getId()).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithAuthorizationBearerHeader(token);
        return this.getOAuth2TokenResponse(tokenEndpointUri, headers, parameters, subdomain, false);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaRefreshToken(@Nonnull URI tokenEndpointUri, @Nonnull ClientIdentity clientIdentity, @Nonnull String refreshToken, String subdomain, boolean disableCacheForRequest) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Assertions.assertNotNull(refreshToken, "refreshToken is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("refresh_token").withRefreshToken(refreshToken).withClientIdentity(clientIdentity).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.getOAuth2TokenResponse(tokenEndpointUri, headers, parameters, subdomain, disableCacheForRequest);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaPasswordGrant(@Nonnull URI tokenEndpoint, @Nonnull ClientIdentity clientIdentity, @Nonnull String username, @Nonnull String password, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters, boolean disableCacheForRequest) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpoint, "tokenEndpoint is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Assertions.assertNotNull(username, "username is required");
        Assertions.assertNotNull(password, "password is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("password").withUsername(username).withPassword(password).withClientIdentity(clientIdentity).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.getOAuth2TokenResponse(tokenEndpoint, headers, parameters, subdomain, disableCacheForRequest);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaJwtBearerTokenGrant(URI tokenEndpoint, ClientIdentity clientIdentity, String token, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters, boolean disableCacheForRequest) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpoint, "tokenEndpoint is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Assertions.assertNotNull(token, "token is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer").withClientIdentity(clientIdentity).withToken(token).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.getOAuth2TokenResponse(tokenEndpoint, headers, parameters, subdomain, disableCacheForRequest);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaJwtBearerTokenGrant(URI tokenEndpoint, ClientIdentity clientIdentity, @Nonnull String token, @Nullable Map<String, String> optionalParameters, boolean disableCacheForRequest, @Nonnull String zoneId) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpoint, "tokenEndpoint is required");
        Assertions.assertNotNull(clientIdentity, "clientIdentity is required");
        Assertions.assertNotNull(token, "token is required");
        Assertions.assertNotNull(zoneId, "ZoneId is required to create X-zid header");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer").withClientIdentity(clientIdentity).withToken(token).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader().withHeader("X-zid", zoneId);
        if (this.isCacheDisabled() || disableCacheForRequest) {
            return this.requestAccessToken(tokenEndpoint, headers, parameters);
        }
        return this.getOrRequestAccessToken(tokenEndpoint, headers, parameters);
    }

    protected abstract OAuth2TokenResponse requestAccessToken(URI var1, HttpHeaders var2, Map<String, String> var3) throws OAuth2ServiceException;

    private OAuth2TokenResponse getOAuth2TokenResponse(@Nonnull URI tokenEndpointUri, HttpHeaders headers, Map<String, String> additionalParameters, @Nullable String subdomain, boolean disableCacheForRequest) throws OAuth2ServiceException {
        URI tokenEndpointUriWithSubdomainReplaced = UriUtil.replaceSubdomain(tokenEndpointUri, subdomain);
        if (this.isCacheDisabled() || disableCacheForRequest) {
            return this.requestAccessToken(tokenEndpointUriWithSubdomainReplaced, headers, additionalParameters);
        }
        return this.getOrRequestAccessToken(tokenEndpointUriWithSubdomainReplaced, headers, additionalParameters);
    }

    private OAuth2TokenResponse getOrRequestAccessToken(URI tokenEndpoint, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        LOGGER.debug("Token was requested for endpoint uri={} with headers={} and parameters={}", new Object[]{tokenEndpoint, headers, parameters});
        CacheKey cacheKey = new CacheKey(tokenEndpoint, headers, parameters);
        OAuth2TokenResponse oAuth2TokenResponse = (OAuth2TokenResponse)this.responseCache.getIfPresent((Object)cacheKey);
        if (oAuth2TokenResponse == null) {
            LOGGER.debug("Token not found in cache, requesting a new one");
            this.getAndCacheToken(cacheKey);
        } else {
            LOGGER.debug("The token was found in cache");
            Duration delta = this.getCacheConfiguration().getTokenExpirationDelta();
            Instant expiration = oAuth2TokenResponse.getExpiredAt().minus(delta);
            if (expiration.isBefore(Instant.now(this.getClock()))) {
                LOGGER.debug("The cached token needs to be refreshed, requesting a new one");
                this.getAndCacheToken(cacheKey);
            }
        }
        OAuth2TokenResponse response = (OAuth2TokenResponse)this.responseCache.getIfPresent((Object)cacheKey);
        this.logDebug(response);
        return response;
    }

    private void logDebug(OAuth2TokenResponse response) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        try {
            DecodedJwt decodedJwt = response.getDecodedAccessToken();
            LOGGER.debug("Access token: {}", (Object)decodedJwt);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Access token can not be logged. {}", (Object)e.getMessage());
        }
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    private void getAndCacheToken(CacheKey cacheKey) throws OAuth2ServiceException {
        this.responseCache.put((Object)cacheKey, (Object)this.requestAccessToken(cacheKey.tokenEndpointUri, cacheKey.headers, cacheKey.parameters));
    }

    private boolean isCacheDisabled() {
        return this.getCacheConfiguration().isCacheDisabled();
    }

    private Cache<CacheKey, OAuth2TokenResponse> createResponseCache(Ticker cacheTicker, boolean sameThreadCache) {
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumSize((long)this.getCacheConfiguration().getCacheSize()).ticker(cacheTicker).expireAfterWrite(this.getCacheConfiguration().getCacheDuration());
        if (sameThreadCache) {
            cacheBuilder.executor(Runnable::run);
        }
        if (this.getCacheConfiguration().isCacheStatisticsEnabled()) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder.build();
    }

    @Override
    public Object getCacheStatistics() {
        return this.getCacheConfiguration().isCacheStatisticsEnabled() ? this.responseCache.stats() : null;
    }

    private class CacheKey {
        private final URI tokenEndpointUri;
        private final HttpHeaders headers;
        private final Map<String, String> parameters;

        public CacheKey(URI tokenEndpointUri, HttpHeaders headers, Map<String, String> parameters) {
            this.tokenEndpointUri = tokenEndpointUri;
            this.headers = headers;
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.tokenEndpointUri, cacheKey.tokenEndpointUri) && Objects.equals(this.headers, cacheKey.headers) && Objects.equals(this.parameters, cacheKey.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.tokenEndpointUri, this.headers, this.parameters);
        }

        public String toString() {
            return "CacheKey{tokenEndpointUri=" + this.tokenEndpointUri + ", headers=" + this.headers + ", parameters=" + this.parameters + '}';
        }
    }
}

