/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaDefaultEndpoints
implements OAuth2ServiceEndpointsProvider {
    private final URI baseUri;
    private final URI certUri;
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private static final String AUTHORIZE_ENDPOINT = "/oauth/authorize";
    private static final String KEYSET_ENDPOINT = "/token_keys";
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaDefaultEndpoints.class);

    @Deprecated
    public XsuaaDefaultEndpoints(URI baseUri) {
        Assertions.assertNotNull(baseUri, "XSUAA base URI must not be null.");
        LOGGER.debug("Xsuaa default service endpoint = {}", (Object)baseUri);
        this.baseUri = baseUri;
        this.certUri = null;
    }

    public XsuaaDefaultEndpoints(@Nonnull OAuth2ServiceConfiguration config) {
        Assertions.assertNotNull(config, "OAuth2ServiceConfiguration must not be null.");
        this.baseUri = config.getUrl();
        this.certUri = config.getCredentialType() == CredentialType.X509 ? config.getCertUrl() : null;
    }

    @Deprecated
    public XsuaaDefaultEndpoints(String baseUri) {
        this(URI.create(baseUri));
    }

    @Override
    public URI getTokenEndpoint() {
        return UriUtil.expandPath(this.certUri != null ? this.certUri : this.baseUri, TOKEN_ENDPOINT);
    }

    @Override
    public URI getAuthorizeEndpoint() {
        return UriUtil.expandPath(this.certUri != null ? this.certUri : this.baseUri, AUTHORIZE_ENDPOINT);
    }

    @Override
    public URI getJwksUri() {
        return UriUtil.expandPath(this.baseUri, KEYSET_ENDPOINT);
    }
}

