/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.xsa.security.container.XSTokenRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class XsuaaTokenFlowRequest
implements XSTokenRequest {
    private ClientIdentity clientIdentity;
    private String clientId;
    private String clientSecret;
    private final URI tokenServiceEndpoint;
    private String subdomain;
    private String zoneId;
    private Map<String, String> additionalAuthorizationAttributes;
    private static final String UNSUPPORTED_INTF_METHOD_INFO = "This XSTokenRequest method is no longer needed in context of new XsuaaTokenFlows API.";

    XsuaaTokenFlowRequest(@Nonnull URI tokenServiceEndpoint) {
        Assertions.assertNotNull(tokenServiceEndpoint, "tokenServiceEndpoint is required");
        this.tokenServiceEndpoint = tokenServiceEndpoint;
    }

    public URI getTokenEndpoint() {
        return this.tokenServiceEndpoint;
    }

    public String getClientId() {
        return this.clientIdentity == null ? this.clientId : this.clientIdentity.getId();
    }

    public XSTokenRequest setClientId(String clientId) {
        Assertions.assertNotNull(clientId, "OAuth 2.0 client ID must not be null.");
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientIdentity == null ? this.clientSecret : this.clientIdentity.getSecret();
    }

    public XSTokenRequest setClientSecret(String clientSecret) {
        Assertions.assertNotNull(clientSecret, "OAuth 2.0 client secret must not be null.");
        this.clientSecret = clientSecret;
        return this;
    }

    public XSTokenRequest setClientIdentity(ClientIdentity clientIdentity) {
        Assertions.assertNotNull(clientIdentity, "OAuth 2.0 client identification must not be null.");
        this.clientIdentity = clientIdentity;
        return this;
    }

    public ClientIdentity getClientIdentity() {
        return this.clientIdentity;
    }

    public Map<String, String> getAdditionalAuthorizationAttributes() {
        return this.additionalAuthorizationAttributes;
    }

    public XSTokenRequest setAdditionalAuthorizationAttributes(Map<String, String> additionalAuthorizationAttributes) {
        this.additionalAuthorizationAttributes = new HashMap<String, String>(additionalAuthorizationAttributes);
        return this;
    }

    @Deprecated
    public XSTokenRequest setType(int type) {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    @Deprecated
    public int getType() {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    @Deprecated
    public XSTokenRequest setTokenEndpoint(URI tokenUri) {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    public boolean isValid() {
        return this.getTokenEndpoint() != null && this.clientIdentity.isValid();
    }

    @Nullable
    public String getSubdomain() {
        return this.subdomain;
    }

    public XSTokenRequest setSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    public XSTokenRequest setZoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }
}

