/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.client;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClientFactory.class);

    @Override
    public CloseableHttpClient createClient(ClientIdentity clientIdentity) throws HttpClientException {
        LOGGER.warn("In productive environment provide well configured HttpClientFactory service");
        if (clientIdentity != null && clientIdentity.isCertificateBased()) {
            SSLContext sslContext;
            LOGGER.debug("Setting up HTTPS client with: certificate: {}\n", (Object)clientIdentity.getCertificate());
            try {
                sslContext = SSLContextFactory.getInstance().create(clientIdentity);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientException(String.format("Couldn't set up https client for service provider. %s.", e.getLocalizedMessage()));
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLContext(sslContext).setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
        }
        LOGGER.debug("Setting up default http client");
        return HttpClients.createDefault();
    }
}

