/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.client;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClientFactory.class);
    final ConcurrentHashMap<String, SslConnection> sslConnectionPool = new ConcurrentHashMap();
    final Set<String> httpClientsCreated = Collections.synchronizedSet(new HashSet());
    static final int MAX_CONNECTIONS_PER_ROUTE = 4;
    static final int MAX_CONNECTIONS = 20;
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private final RequestConfig customConfig = RequestConfig.custom().setConnectTimeout(DEFAULT_TIMEOUT).setConnectionRequestTimeout(DEFAULT_TIMEOUT).setSocketTimeout(DEFAULT_TIMEOUT).setRedirectsEnabled(false).build();

    @Override
    public CloseableHttpClient createClient(ClientIdentity clientIdentity) throws HttpClientException {
        String clientId;
        String string = clientId = clientIdentity != null ? clientIdentity.getId() : null;
        if (this.httpClientsCreated.contains(clientId)) {
            LOGGER.warn("Application has already created HttpClient for clientId = {}, please check.", (Object)clientId);
        }
        this.httpClientsCreated.add(clientId);
        if (clientId != null && clientIdentity.isCertificateBased()) {
            LOGGER.info("In productive environment provide well configured HttpClientFactory service");
            SslConnection connectionPool = this.sslConnectionPool.computeIfAbsent(clientId, s -> new SslConnection(clientIdentity));
            return HttpClients.custom().setDefaultRequestConfig(this.customConfig).setConnectionManager((HttpClientConnectionManager)connectionPool.poolingConnectionManager).setSSLContext(connectionPool.context).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionPool.sslSocketFactory).build();
        }
        LOGGER.warn("In productive environment provide well configured HttpClientFactory service, don't use default http client");
        return HttpClients.custom().disableRedirectHandling().build();
    }

    private static class SslConnection {
        SSLContext context;
        SSLConnectionSocketFactory sslSocketFactory;
        PoolingHttpClientConnectionManager poolingConnectionManager;

        public SslConnection(ClientIdentity clientIdentity) {
            try {
                this.context = SSLContextFactory.getInstance().create(clientIdentity);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientException(String.format("Couldn't set up https client for service provider %s. %s.", clientIdentity.getId(), e.getLocalizedMessage()));
            }
            this.sslSocketFactory = new SSLConnectionSocketFactory(this.context);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.sslSocketFactory).build();
            this.poolingConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            this.poolingConnectionManager.setDefaultMaxPerRoute(4);
            this.poolingConnectionManager.setMaxTotal(20);
        }
    }
}

