/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;

public class DefaultOidcConfigurationService
implements OidcConfigurationService {
    private final CloseableHttpClient httpClient;

    public DefaultOidcConfigurationService() {
        this.httpClient = HttpClientFactory.create(null);
    }

    public DefaultOidcConfigurationService(CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    public static URI getDiscoveryEndpointUri(@Nonnull String issuerUri) {
        URI uri = URI.create(issuerUri.startsWith("http") ? issuerUri : "https://" + issuerUri);
        return UriUtil.expandPath(uri, "/.well-known/openid-configuration");
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        OAuth2ServiceEndpointsProvider oAuth2ServiceEndpointsProvider;
        block8: {
            Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
            HttpGet request = new HttpGet(discoveryEndpointUri);
            request.addHeader("User-Agent", HttpClientUtil.getUserAgent());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            try {
                String bodyAsString = HttpClientUtil.extractResponseBodyAsString((HttpResponse)response);
                int statusCode = response.getStatusLine().getStatusCode();
                oAuth2ServiceEndpointsProvider = this.handleResponse(bodyAsString, statusCode, discoveryEndpointUri);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints: " + e.getMessage()).withUri(discoveryEndpointUri).build();
                }
            }
            response.close();
        }
        return oAuth2ServiceEndpointsProvider;
    }

    private OAuth2ServiceEndpointsProvider handleResponse(String bodyAsString, int statusCode, URI discoveryEndpointUri) throws OAuth2ServiceException {
        if (statusCode == 200) {
            return new OidcEndpointsProvider(bodyAsString);
        }
        throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withStatusCode(statusCode).withResponseBody(bodyAsString).build();
    }

    static class OidcEndpointsProvider
    implements OAuth2ServiceEndpointsProvider {
        static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        static final String TOKEN_ENDPOINT = "token_endpoint";
        static final String JWKS_ENDPOINT = "jwks_uri";
        private JSONObject jsonObject;

        OidcEndpointsProvider(String jsonString) {
            this.jsonObject = new JSONObject(jsonString);
        }

        @Override
        public URI getTokenEndpoint() {
            return URI.create(this.jsonObject.getString(TOKEN_ENDPOINT));
        }

        @Override
        public URI getAuthorizeEndpoint() {
            return URI.create(this.jsonObject.getString(AUTHORIZATION_ENDPOINT));
        }

        @Override
        public URI getJwksUri() {
            return URI.create(this.jsonObject.getString(JWKS_ENDPOINT));
        }
    }
}

