/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class SpringOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringOAuth2TokenKeyService.class);
    private final RestOperations restOperations;

    public SpringOAuth2TokenKeyService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
    }

    @Override
    public String retrieveTokenKeys(@Nonnull URI tokenKeysEndpointUri, @Nullable String zoneId) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            headers.set("User-Agent", HttpClientUtil.getUserAgent());
            if (zoneId != null) {
                headers.set("x-zone_uuid", zoneId);
            }
            ResponseEntity response = this.restOperations.exchange(tokenKeysEndpointUri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class);
            if (HttpStatus.OK.value() == response.getStatusCode().value()) {
                LOGGER.debug("Successfully retrieved token keys from {} for zone '{}'", (Object)tokenKeysEndpointUri, (Object)zoneId);
                return (String)response.getBody();
            }
            throw OAuth2ServiceException.builder("Error retrieving token keys").withUri(tokenKeysEndpointUri).withHeaders("x-zone_uuid=" + zoneId).withStatusCode(response.getStatusCodeValue()).withResponseBody((String)response.getBody()).build();
        }
        catch (HttpStatusCodeException ex) {
            throw OAuth2ServiceException.builder("Error retrieving token keys").withUri(tokenKeysEndpointUri).withHeaders("x-zone_uuid=" + zoneId).withStatusCode(ex.getStatusCode().value()).withResponseBody(ex.getResponseBodyAsString()).build();
        }
        catch (Exception e) {
            throw OAuth2ServiceException.builder("Unexpected error retrieving token keys: " + e.getMessage()).withUri(tokenKeysEndpointUri).build();
        }
    }
}

