/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowRequest;
import com.sap.xsa.security.container.XSTokenRequest;

public class RefreshTokenFlow {
    private final XsuaaTokenFlowRequest request;
    private String refreshToken;
    private final OAuth2TokenService tokenService;
    private boolean disableCache = false;

    RefreshTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientIdentity clientIdentity) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null.");
        this.tokenService = tokenService;
        this.request = new XsuaaTokenFlowRequest(endpointsProvider.getTokenEndpoint());
        this.request.setClientIdentity(clientIdentity);
    }

    public RefreshTokenFlow subdomain(String subdomain) {
        this.request.setSubdomain(subdomain);
        return this;
    }

    public RefreshTokenFlow refreshToken(String refreshToken) {
        Assertions.assertNotNull(refreshToken, "RefreshToken must not be null.");
        this.refreshToken = refreshToken;
        return this;
    }

    public RefreshTokenFlow disableCache(boolean disableCache) {
        this.disableCache = disableCache;
        return this;
    }

    public OAuth2TokenResponse execute() throws IllegalStateException, IllegalArgumentException, TokenFlowException {
        this.checkRequest(this.request);
        return this.refreshToken(this.refreshToken, this.request);
    }

    private void checkRequest(XSTokenRequest request) throws IllegalStateException, IllegalArgumentException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("Refresh token not set. Make sure to have called the refreshToken() method on RefreshTokenFlow builder.");
        }
        if (!request.isValid()) {
            throw new IllegalArgumentException("Refresh token flow request is not valid. Make sure all mandatory fields are set.");
        }
    }

    private OAuth2TokenResponse refreshToken(String refreshToken, XsuaaTokenFlowRequest request) throws TokenFlowException {
        try {
            return this.tokenService.retrieveAccessTokenViaRefreshToken(request.getTokenEndpoint(), request.getClientIdentity(), refreshToken, request.getSubdomain(), this.disableCache);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error refreshing token with grant_type 'refresh_token': %s", e.getMessage()), e);
        }
    }
}

