/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowRequest;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowsUtils;
import com.sap.xsa.security.container.XSTokenRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class UserTokenFlow {
    private final XsuaaTokenFlowRequest request;
    private String token;
    private String xZid;
    private final OAuth2TokenService tokenService;
    private boolean disableCache = false;
    private List<String> scopes = new ArrayList<String>();

    UserTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientIdentity clientIdentity) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null.");
        this.tokenService = tokenService;
        this.request = new XsuaaTokenFlowRequest(endpointsProvider.getTokenEndpoint());
        this.request.setClientIdentity(clientIdentity);
    }

    public UserTokenFlow token(String encodedToken) {
        Assertions.assertNotNull(encodedToken, "(Encoded) token must not be null.");
        this.token = encodedToken;
        return this;
    }

    public UserTokenFlow token(Token token) {
        Assertions.assertNotNull(token, "Token must not be null.");
        this.token = token.getTokenValue();
        this.xZid = token.getZoneId();
        return this;
    }

    public UserTokenFlow attributes(Map<String, String> additionalAuthorizationAttributes) {
        this.request.setAdditionalAuthorizationAttributes(additionalAuthorizationAttributes);
        return this;
    }

    public UserTokenFlow subdomain(String subdomain) {
        this.request.setSubdomain(subdomain);
        return this;
    }

    public UserTokenFlow scopes(String ... scopes) {
        Assertions.assertNotNull(scopes, "Scopes must not be null!");
        this.scopes = Arrays.asList(scopes);
        return this;
    }

    public UserTokenFlow disableCache(boolean disableCache) {
        this.disableCache = disableCache;
        return this;
    }

    public OAuth2TokenResponse execute() throws TokenFlowException {
        this.checkRequest(this.request);
        return this.requestUserToken(this.request);
    }

    private void checkRequest(XSTokenRequest request) throws IllegalArgumentException {
        if (this.token == null) {
            throw new IllegalStateException("User token not set. Make sure to have called the token() method on UserTokenFlow builder.");
        }
        if (!request.isValid()) {
            throw new IllegalArgumentException("User token flow request is not valid. Make sure all mandatory fields are set.");
        }
    }

    private OAuth2TokenResponse requestUserToken(XsuaaTokenFlowRequest request) throws TokenFlowException {
        String scopesParameter;
        HashMap<String, String> optionalParameter = new HashMap<String, String>();
        String authorities = XsuaaTokenFlowsUtils.buildAuthorities(request);
        if (authorities != null) {
            optionalParameter.put("authorities", authorities);
        }
        if (!(scopesParameter = String.join((CharSequence)" ", this.scopes)).isEmpty()) {
            optionalParameter.put("scope", scopesParameter);
        }
        try {
            if (this.xZid == null) {
                return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(request.getTokenEndpoint(), (ClientIdentity)new ClientCredentials(request.getClientId(), request.getClientSecret()), this.token, request.getSubdomain(), optionalParameter, this.disableCache);
            }
            return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(request.getTokenEndpoint(), request.getClientIdentity(), this.token, optionalParameter, this.disableCache, this.xZid);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error requesting token with grant_type 'urn:ietf:params:oauth:grant-type:jwt-bearer': %s", e.getMessage()), e);
        }
    }
}

