/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.ClientCredentialsTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.JwtBearerTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.PasswordTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.RefreshTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.UserTokenFlow;
import java.io.Serializable;

public class XsuaaTokenFlows
implements Serializable {
    private static final long serialVersionUID = 2403173341950251507L;
    private final ClientIdentity clientIdentity;
    private final OAuth2TokenService oAuth2TokenService;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;

    @Deprecated
    public XsuaaTokenFlows(OAuth2TokenService oAuth2TokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientCredentials clientCredentials) {
        Assertions.assertNotNull(oAuth2TokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null");
        Assertions.assertNotNull((Object)clientCredentials, "ClientCredentials must not be null.");
        this.oAuth2TokenService = oAuth2TokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientIdentity = new com.sap.cloud.security.config.ClientCredentials(clientCredentials.getId(), clientCredentials.getSecret());
    }

    public XsuaaTokenFlows(OAuth2TokenService oAuth2TokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientIdentity clientIdentity) {
        Assertions.assertNotNull(oAuth2TokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null.");
        this.oAuth2TokenService = oAuth2TokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientIdentity = clientIdentity;
    }

    @Deprecated
    public UserTokenFlow userTokenFlow() {
        return new UserTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientIdentity);
    }

    public JwtBearerTokenFlow jwtBearerTokenFlow() {
        return new JwtBearerTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientIdentity);
    }

    public ClientCredentialsTokenFlow clientCredentialsTokenFlow() {
        return new ClientCredentialsTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientIdentity);
    }

    public RefreshTokenFlow refreshTokenFlow() {
        return new RefreshTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientIdentity);
    }

    public PasswordTokenFlow passwordTokenFlow() {
        return new PasswordTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientIdentity);
    }
}

