/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.RequestParameterBuilder;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.http.HttpHeadersFactory;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractOAuth2TokenService
implements OAuth2TokenService {
    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaClientCredentialsGrant(@Nonnull URI tokenEndpointUri, @Nonnull ClientCredentials clientCredentials, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientCredentials, "clientCredentials is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("client_credentials").withClientCredentials(clientCredentials).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.requestAccessToken(UriUtil.replaceSubdomain(tokenEndpointUri, subdomain), headers, parameters);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaUserTokenGrant(@Nonnull URI tokenEndpointUri, @Nonnull ClientCredentials clientCredentials, @Nonnull String token, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientCredentials, "clientCredentials is required");
        Assertions.assertNotNull(token, "token is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("user_token").withClientId(clientCredentials.getId()).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithAuthorizationBearerHeader(token);
        return this.requestAccessToken(UriUtil.replaceSubdomain(tokenEndpointUri, subdomain), headers, parameters);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaRefreshToken(@Nonnull URI tokenEndpointUri, @Nonnull ClientCredentials clientCredentials, @Nonnull String refreshToken, String subdomain) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "tokenEndpointUri is required");
        Assertions.assertNotNull(clientCredentials, "clientCredentials is required");
        Assertions.assertNotNull(refreshToken, "refreshToken is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("refresh_token").withRefreshToken(refreshToken).withClientCredentials(clientCredentials).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.requestAccessToken(UriUtil.replaceSubdomain(tokenEndpointUri, subdomain), headers, parameters);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaPasswordGrant(@Nonnull URI tokenEndpoint, @Nonnull ClientCredentials clientCredentials, @Nonnull String username, @Nonnull String password, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpoint, "tokenEndpoint is required");
        Assertions.assertNotNull(clientCredentials, "clientCredentials are required");
        Assertions.assertNotNull(username, "username is required");
        Assertions.assertNotNull(password, "password is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("password").withUsername(username).withPassword(password).withClientCredentials(clientCredentials).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.requestAccessToken(UriUtil.replaceSubdomain(tokenEndpoint, subdomain), headers, parameters);
    }

    @Override
    public OAuth2TokenResponse retrieveAccessTokenViaJwtBearerTokenGrant(URI tokenEndpoint, ClientCredentials clientCredentials, String token, @Nullable String subdomain, @Nullable Map<String, String> optionalParameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpoint, "tokenEndpoint is required");
        Assertions.assertNotNull(clientCredentials, "clientCredentials are required");
        Assertions.assertNotNull(token, "token is required");
        Map<String, String> parameters = new RequestParameterBuilder().withGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer").withClientCredentials(clientCredentials).withToken(token).withOptionalParameters(optionalParameters).buildAsMap();
        HttpHeaders headers = HttpHeadersFactory.createWithoutAuthorizationHeader();
        return this.requestAccessToken(UriUtil.replaceSubdomain(tokenEndpoint, subdomain), headers, parameters);
    }

    protected abstract OAuth2TokenResponse requestAccessToken(URI var1, HttpHeaders var2, Map<String, String> var3) throws OAuth2ServiceException;
}

