/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ClientCredentials {
    private final String clientSecret;
    private final String clientId;

    public ClientCredentials(@Nonnull String clientId, @Nonnull String clientSecret) {
        Assertions.assertNotNull(clientId, "clientId is required");
        Assertions.assertNotNull(clientSecret, "clientSecret is required");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String getSecret() {
        return this.clientSecret;
    }

    public String getId() {
        return this.clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCredentials that = (ClientCredentials)o;
        return Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.clientSecret, this.clientId);
    }

    public String toString() {
        return String.format("%s:%s", this.clientId, this.clientSecret);
    }
}

