/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.client.AbstractOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenService
extends AbstractOAuth2TokenService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOAuth2TokenService.class);
    private final CloseableHttpClient httpClient;

    public DefaultOAuth2TokenService() {
        this.httpClient = HttpClients.createDefault();
    }

    public DefaultOAuth2TokenService(CloseableHttpClient client) {
        this.httpClient = client;
    }

    @Override
    protected OAuth2TokenResponse requestAccessToken(URI tokenEndpointUri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        HttpPost httpPost = this.createHttpPost(tokenEndpointUri, headers, parameters);
        return this.executeRequest(httpPost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OAuth2TokenResponse executeRequest(HttpPost httpPost) throws OAuth2ServiceException {
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                OAuth2TokenResponse oAuth2TokenResponse = this.handleResponse((HttpResponse)response);
                return oAuth2TokenResponse;
            }
            String responseBodyAsString = HttpClientUtil.extractResponseBodyAsString((HttpResponse)response);
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving JWT token", statusCode, responseBodyAsString);
        }
        catch (IOException e) {
            throw new OAuth2ServiceException("Unexpected error retrieving JWT token: " + e.getMessage());
        }
    }

    private OAuth2TokenResponse handleResponse(HttpResponse response) throws IOException {
        String responseBody = HttpClientUtil.extractResponseBodyAsString(response);
        Map accessTokenMap = new JSONObject(responseBody).toMap();
        logger.debug("Request Access Token: {}", (Object)accessTokenMap);
        return this.convertToOAuth2TokenResponse(accessTokenMap);
    }

    private OAuth2TokenResponse convertToOAuth2TokenResponse(Map<String, Object> accessTokenMap) throws OAuth2ServiceException {
        String accessToken = this.getParameter(accessTokenMap, "access_token");
        String refreshToken = this.getParameter(accessTokenMap, "refresh_token");
        String expiresIn = this.getParameter(accessTokenMap, "expires_in");
        return new OAuth2TokenResponse(accessToken, this.convertExpiresInToLong(expiresIn), refreshToken);
    }

    private Long convertExpiresInToLong(String expiresIn) throws OAuth2ServiceException {
        try {
            return Long.parseLong(expiresIn);
        }
        catch (NumberFormatException e) {
            throw new OAuth2ServiceException(String.format("Cannot convert expires_in from response (%s) to long", expiresIn));
        }
    }

    private String getParameter(Map<String, Object> accessTokenMap, String key) {
        return String.valueOf(accessTokenMap.get(key));
    }

    private HttpPost createHttpPost(URI uri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        HttpPost httpPost = new HttpPost(uri);
        headers.getHeaders().forEach(header -> httpPost.setHeader(header.getName(), header.getValue()));
        try {
            List basicNameValuePairs = parameters.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(basicNameValuePairs));
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2ServiceException("Unexpected error parsing URI: " + e.getMessage());
        }
        return httpPost;
    }
}

