/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOidcConfigurationService
implements OidcConfigurationService {
    static final Logger logger = LoggerFactory.getLogger(DefaultOidcConfigurationService.class);
    private final CloseableHttpClient httpClient;

    public DefaultOidcConfigurationService() {
        this.httpClient = HttpClients.createDefault();
    }

    public DefaultOidcConfigurationService(CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    public static URI getDiscoveryEndpointUri(@Nonnull String issuerUri) {
        URI uri = URI.create(issuerUri.startsWith("http") ? issuerUri : "https://" + issuerUri);
        return UriUtil.expandPath(uri, "/.well-known/openid-configuration");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        HttpGet request = new HttpGet(discoveryEndpointUri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            String bodyAsString = HttpClientUtil.extractResponseBodyAsString((HttpResponse)response);
            int statusCode = response.getStatusLine().getStatusCode();
            OAuth2ServiceEndpointsProvider oAuth2ServiceEndpointsProvider = this.handleResponse(bodyAsString, statusCode);
            return oAuth2ServiceEndpointsProvider;
        }
        catch (IOException e) {
            throw new OAuth2ServiceException("Error retrieving configured oidc endpoints from " + discoveryEndpointUri + " : " + e.getMessage());
        }
    }

    private OAuth2ServiceEndpointsProvider handleResponse(String bodyAsString, int statusCode) throws OAuth2ServiceException {
        if (statusCode == 200) {
            return new OidcEndpointsProvider(bodyAsString);
        }
        throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving configured oidc endpoints", statusCode, bodyAsString);
    }

    static class OidcEndpointsProvider
    implements OAuth2ServiceEndpointsProvider {
        static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        static final String TOKEN_ENDPOINT = "token_endpoint";
        static final String JWKS_ENDPOINT = "jwks_uri";
        private JSONObject jsonObject;

        OidcEndpointsProvider(String jsonString) {
            this.jsonObject = new JSONObject(jsonString);
        }

        @Override
        public URI getTokenEndpoint() {
            return URI.create(this.jsonObject.getString(TOKEN_ENDPOINT));
        }

        @Override
        public URI getAuthorizeEndpoint() {
            return URI.create(this.jsonObject.getString(AUTHORIZATION_ENDPOINT));
        }

        @Override
        public URI getJwksUri() {
            return URI.create(this.jsonObject.getString(JWKS_ENDPOINT));
        }
    }
}

