/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import java.net.URI;
import javax.annotation.Nonnull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;

public class SpringOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private final RestOperations restOperations;

    public SpringOAuth2TokenKeyService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
    }

    @Override
    public String retrieveTokenKeys(URI tokenKeysEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        try {
            ResponseEntity response = this.restOperations.getForEntity(tokenKeysEndpointUri, String.class);
            if (HttpStatus.OK.value() == response.getStatusCode().value()) {
                return (String)response.getBody();
            }
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving token keys", response.getStatusCodeValue(), (String)response.getBody());
        }
        catch (HttpClientErrorException ex) {
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving token keys", ex.getStatusCode().value(), ex.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Unexpected error retrieving token keys", 500, e.getMessage());
        }
    }
}

