/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import java.net.URI;
import javax.annotation.Nonnull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;

public class SpringOidcConfigurationService
implements OidcConfigurationService {
    private final RestOperations restOperations;

    public SpringOidcConfigurationService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        try {
            ResponseEntity response = this.restOperations.getForEntity(discoveryEndpointUri, String.class);
            if (HttpStatus.OK.value() == response.getStatusCode().value()) {
                return new DefaultOidcConfigurationService.OidcEndpointsProvider((String)response.getBody());
            }
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving configured oidc endpoints", response.getStatusCodeValue(), (String)response.getBody());
        }
        catch (HttpClientErrorException ex) {
            throw OAuth2ServiceException.createWithStatusCodeAndResponseBody("Error retrieving configured oidc endpoints", ex.getStatusCode().value(), ex.getResponseBodyAsString());
        }
    }
}

