/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import java.util.Map;
import javax.annotation.Nonnull;

public class PasswordTokenFlow {
    private final OAuth2TokenService tokenService;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;
    private final ClientCredentials clientCredentials;
    private String username;
    private String password;
    private String subdomain;
    private Map<String, String> optionalParameters;

    public PasswordTokenFlow(@Nonnull OAuth2TokenService tokenService, @Nonnull OAuth2ServiceEndpointsProvider endpointsProvider, @Nonnull ClientCredentials clientCredentials) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null!");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null!");
        Assertions.assertNotNull(clientCredentials, "ClientCredentials must not be null!");
        this.tokenService = tokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientCredentials = clientCredentials;
    }

    public OAuth2TokenResponse execute() throws TokenFlowException {
        this.checkParameter(this.username, "Username must be set!");
        this.checkParameter(this.password, "Password must be set!");
        try {
            return this.tokenService.retrieveAccessTokenViaPasswordGrant(this.endpointsProvider.getTokenEndpoint(), this.clientCredentials, this.username, this.password, this.subdomain, this.optionalParameters);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error requesting user token with grant_type 'client_credentials': %s", e.getMessage()), e);
        }
    }

    public PasswordTokenFlow password(String password) {
        this.password = password;
        return this;
    }

    public PasswordTokenFlow username(String username) {
        this.username = username;
        return this;
    }

    public PasswordTokenFlow subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    public PasswordTokenFlow optionalParameters(Map<String, String> optionalParameters) {
        this.optionalParameters = optionalParameters;
        return this;
    }

    private void checkParameter(String parameter, String message) {
        if (parameter == null) {
            throw new IllegalStateException(message);
        }
    }
}

