/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowRequest;
import com.sap.xsa.security.container.XSTokenRequest;

public class RefreshTokenFlow {
    private XsuaaTokenFlowRequest request;
    private String refreshToken;
    private OAuth2TokenService tokenService;

    RefreshTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientCredentials clientCredentials) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientCredentials, "ClientCredentials must not be null.");
        this.tokenService = tokenService;
        this.request = new XsuaaTokenFlowRequest(endpointsProvider.getTokenEndpoint());
        this.request.setClientId(clientCredentials.getId());
        this.request.setClientSecret(clientCredentials.getSecret());
    }

    public RefreshTokenFlow subdomain(String subdomain) {
        this.request.setSubdomain(subdomain);
        return this;
    }

    public RefreshTokenFlow refreshToken(String refreshToken) {
        Assertions.assertNotNull(refreshToken, "RefreshToken must not be null.");
        this.refreshToken = refreshToken;
        return this;
    }

    public OAuth2TokenResponse execute() throws IllegalStateException, IllegalArgumentException, TokenFlowException {
        this.checkRequest(this.request);
        return this.refreshToken(this.refreshToken, this.request);
    }

    private void checkRequest(XSTokenRequest request) throws IllegalStateException, IllegalArgumentException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("Refresh token not set. Make sure to have called the refreshToken() method on RefreshTokenFlow builder.");
        }
        if (!request.isValid()) {
            throw new IllegalArgumentException("Refresh token flow request is not valid. Make sure all mandatory fields are set.");
        }
    }

    private OAuth2TokenResponse refreshToken(String refreshToken, XsuaaTokenFlowRequest request) throws TokenFlowException {
        try {
            OAuth2TokenResponse accessToken = this.tokenService.retrieveAccessTokenViaRefreshToken(request.getTokenEndpoint(), new ClientCredentials(request.getClientId(), request.getClientSecret()), refreshToken, request.getSubdomain());
            return accessToken;
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error refreshing token with grant_type 'refresh_token': %s", e.getMessage()), e);
        }
    }
}

