/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowRequest;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowsUtils;
import com.sap.xsa.security.container.XSTokenRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class UserTokenFlow {
    private static final String AUTHORITIES = "authorities";
    private XsuaaTokenFlowRequest request;
    private String token;
    private OAuth2TokenService tokenService;

    UserTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientCredentials clientCredentials) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientCredentials, "ClientCredentials must not be null.");
        this.tokenService = tokenService;
        this.request = new XsuaaTokenFlowRequest(endpointsProvider.getTokenEndpoint());
        this.request.setClientId(clientCredentials.getId());
        this.request.setClientSecret(clientCredentials.getSecret());
    }

    public UserTokenFlow token(String token) {
        Assertions.assertNotNull(token, "Token must not be null.");
        this.token = token;
        return this;
    }

    public UserTokenFlow attributes(Map<String, String> additionalAuthorizationAttributes) {
        this.request.setAdditionalAuthorizationAttributes(additionalAuthorizationAttributes);
        return this;
    }

    public UserTokenFlow subdomain(String subdomain) {
        this.request.setSubdomain(subdomain);
        return this;
    }

    public OAuth2TokenResponse execute() throws TokenFlowException {
        this.checkRequest(this.request);
        return this.requestUserToken(this.request);
    }

    private void checkRequest(XSTokenRequest request) throws IllegalArgumentException {
        if (this.token == null) {
            throw new IllegalStateException("User token not set. Make sure to have called the token() method on UserTokenFlow builder.");
        }
        if (!request.isValid()) {
            throw new IllegalArgumentException("User token flow request is not valid. Make sure all mandatory fields are set.");
        }
    }

    private OAuth2TokenResponse requestUserToken(XsuaaTokenFlowRequest request) throws TokenFlowException {
        HashMap<String, String> optionalParameter = null;
        String authorities = XsuaaTokenFlowsUtils.buildAuthorities(request);
        if (authorities != null) {
            optionalParameter = new HashMap<String, String>();
            optionalParameter.put(AUTHORITIES, authorities);
        }
        Object refreshToken = null;
        try {
            return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(request.getTokenEndpoint(), new ClientCredentials(request.getClientId(), request.getClientSecret()), this.token, request.getSubdomain(), optionalParameter);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error requesting token with grant_type 'urn:ietf:params:oauth:grant-type:jwt-bearer': %s", e.getMessage()), e);
        }
    }

    @Nullable
    private String readFromPropertyFile(String property) {
        String rootPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        String appConfigPath = rootPath + "application.properties";
        Properties appProps = new Properties();
        try {
            appProps.load(new FileInputStream(appConfigPath));
            return appProps.getProperty(property);
        }
        catch (IOException e) {
            return null;
        }
    }
}

