/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OAuth2TokenResponse {
    private String refreshToken;
    private String accessToken;
    private long expiredTimeMillis;

    public OAuth2TokenResponse(@Nullable String accessToken, long expiredInSeconds, @Nullable String refreshToken) {
        this.accessToken = accessToken;
        this.expiredTimeMillis = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expiredInSeconds);
        this.refreshToken = refreshToken;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public DecodedJwt getDecodedAccessToken() {
        if (this.accessToken == null) {
            return null;
        }
        return Base64JwtDecoder.getInstance().decode(this.accessToken);
    }

    @Deprecated
    public Date getExpiredAtDate() {
        return new Date(this.expiredTimeMillis);
    }

    public Instant getExpiredAt() {
        return Instant.ofEpochMilli(this.expiredTimeMillis);
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String toString() {
        DecodedJwt decodedJwt = null;
        try {
            decodedJwt = this.getDecodedAccessToken();
        }
        catch (IllegalArgumentException e) {
            return super.toString();
        }
        return decodedJwt.toString();
    }
}

