/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.http;

import com.sap.cloud.security.xsuaa.http.HttpHeader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpHeaders {
    public static final String AUTHORIZATION = "Authorization";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    private final Set<HttpHeader> headers;

    public HttpHeaders(HttpHeader ... headers) {
        this(Arrays.asList(headers));
    }

    public HttpHeaders(Collection<HttpHeader> headers) {
        this.headers = headers.stream().collect(Collectors.toSet());
    }

    public Set<HttpHeader> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public String toString() {
        return "HttpHeaders{headers=" + this.headers + '}';
    }
}

