/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class DefaultOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private final CloseableHttpClient httpClient;

    public DefaultOAuth2TokenKeyService() {
        this.httpClient = HttpClients.createDefault();
    }

    public DefaultOAuth2TokenKeyService(@Nonnull CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String retrieveTokenKeys(URI tokenKeysEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        HttpGet request = new HttpGet(tokenKeysEndpointUri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            String bodyAsString = HttpClientUtil.extractResponseBodyAsString((HttpResponse)response);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String string = bodyAsString;
                return string;
            }
            throw OAuth2ServiceException.builder("Error retrieving token keys").withUri(tokenKeysEndpointUri).withStatusCode(statusCode).withResponseBody(bodyAsString).build();
        }
        catch (IOException e) {
            throw new OAuth2ServiceException("Error retrieving token keys: " + e.getMessage());
        }
    }
}

