/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.util;

import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriUtil {
    private static final Logger logger = LoggerFactory.getLogger(UriUtil.class);

    private UriUtil() {
    }

    public static URI replaceSubdomain(@Nonnull URI uri, @Nullable String subdomain) {
        Assertions.assertNotNull(uri, "the uri parameter must not be null");
        if (UriUtil.hasText(subdomain) && UriUtil.hasSubdomain(uri)) {
            String newHost = subdomain + uri.getHost().substring(uri.getHost().indexOf(46));
            try {
                return uri.resolve(new URI(uri.getScheme(), uri.getUserInfo(), newHost, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                logger.error("Could not replace subdomain {} in given uri {}", (Object)subdomain, (Object)uri);
                throw new IllegalArgumentException(e);
            }
        }
        logger.debug("the subdomain of the URI '{}' is not replaced by subdomain '{}'", (Object)uri, (Object)subdomain);
        return uri;
    }

    private static boolean hasSubdomain(URI uri) {
        return uri.getHost().contains(".");
    }

    private static boolean hasText(String string) {
        return Optional.ofNullable(string).filter(str -> !str.trim().isEmpty()).isPresent();
    }

    @Nonnull
    public static URI expandPath(URI baseUri, String pathToAppend) {
        try {
            String newPath = baseUri.getPath() + pathToAppend;
            return new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), UriUtil.replaceDoubleSlashes(newPath), baseUri.getQuery(), baseUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private static String replaceDoubleSlashes(String newPath) {
        return newPath.replace("//", "/");
    }
}

