/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.xsa.security.container.XSTokenRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class XsuaaTokenFlowRequest
implements XSTokenRequest {
    private String clientId;
    private URI tokenServiceEndpoint;
    private String subdomain;
    private String clientSecret;
    private Map<String, String> additionalAuthorizationAttributes;
    private static final String UNSUPPORTED_INTF_METHOD_INFO = "This XSTokenRequest method is no longer needed in context of new XsuaaTokenFlows API.";

    XsuaaTokenFlowRequest(@Nonnull URI tokenServiceEndpoint) {
        Assertions.assertNotNull(tokenServiceEndpoint, "tokenServiceEndpoint is required");
        this.tokenServiceEndpoint = tokenServiceEndpoint;
    }

    public URI getTokenEndpoint() {
        return this.tokenServiceEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public XSTokenRequest setClientId(String clientId) {
        Assertions.assertNotNull(clientId, "OAuth 2.0 client ID must not be null.");
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public XSTokenRequest setClientSecret(String clientSecret) {
        Assertions.assertNotNull(clientSecret, "OAuth 2.0 client secret must not be null.");
        this.clientSecret = clientSecret;
        return this;
    }

    public Map<String, String> getAdditionalAuthorizationAttributes() {
        return this.additionalAuthorizationAttributes;
    }

    public XSTokenRequest setAdditionalAuthorizationAttributes(Map<String, String> additionalAuthorizationAttributes) {
        this.additionalAuthorizationAttributes = new HashMap<String, String>(additionalAuthorizationAttributes);
        return this;
    }

    @Deprecated
    public XSTokenRequest setType(int type) {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    @Deprecated
    public int getType() {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    @Deprecated
    public XSTokenRequest setTokenEndpoint(URI tokenUri) {
        throw new AssertionError((Object)UNSUPPORTED_INTF_METHOD_INFO);
    }

    public boolean isValid() {
        return this.getTokenEndpoint() != null && this.clientId != null && this.clientSecret != null;
    }

    @Nullable
    public String getSubdomain() {
        return this.subdomain;
    }

    public XSTokenRequest setSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }
}

