/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.ClientCredentialsTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.PasswordTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.RefreshTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.UserTokenFlow;
import java.io.Serializable;

public class XsuaaTokenFlows
implements Serializable {
    private static final long serialVersionUID = 2403173341950251507L;
    private final ClientCredentials clientCredentials;
    private final OAuth2TokenService oAuth2TokenService;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;

    public XsuaaTokenFlows(OAuth2TokenService oAuth2TokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientCredentials clientCredentials) {
        Assertions.assertNotNull(oAuth2TokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null");
        Assertions.assertNotNull(clientCredentials, "ClientCredentials must not be null.");
        this.oAuth2TokenService = oAuth2TokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientCredentials = clientCredentials;
    }

    public UserTokenFlow userTokenFlow() {
        return new UserTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientCredentials);
    }

    public ClientCredentialsTokenFlow clientCredentialsTokenFlow() {
        return new ClientCredentialsTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientCredentials);
    }

    public RefreshTokenFlow refreshTokenFlow() {
        return new RefreshTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientCredentials);
    }

    public PasswordTokenFlow passwordTokenFlow() {
        return new PasswordTokenFlow(this.oAuth2TokenService, this.endpointsProvider, this.clientCredentials);
    }
}

