/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;

public class XsuaaDefaultEndpoints
implements OAuth2ServiceEndpointsProvider {
    private final URI baseUri;
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private static final String AUTHORIZE_ENDPOINT = "/oauth/authorize";
    private static final String KEYSET_ENDPOINT = "/token_keys";

    public XsuaaDefaultEndpoints(URI baseUri) {
        Assertions.assertNotNull(baseUri, "XSUAA base URI must not be null.");
        this.baseUri = baseUri;
    }

    public XsuaaDefaultEndpoints(String baseUri) {
        this(URI.create(baseUri));
    }

    @Override
    public URI getTokenEndpoint() {
        return UriUtil.expandPath(this.baseUri, TOKEN_ENDPOINT);
    }

    @Override
    public URI getAuthorizeEndpoint() {
        return UriUtil.expandPath(this.baseUri, AUTHORIZE_ENDPOINT);
    }

    @Override
    public URI getJwksUri() {
        return UriUtil.expandPath(this.baseUri, KEYSET_ENDPOINT);
    }
}

