/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2TokenKeyService.class);
    private final CloseableHttpClient httpClient;

    public DefaultOAuth2TokenKeyService() {
        this.httpClient = HttpClientFactory.create(null);
    }

    public DefaultOAuth2TokenKeyService(@Nonnull CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    @Override
    public String retrieveTokenKeys(URI tokenKeysEndpointUri, @Nullable String zoneId) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        HttpGet request = new HttpGet(tokenKeysEndpointUri);
        if (zoneId != null) {
            request.addHeader("x-zone_uuid", zoneId);
        }
        request.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        LOGGER.debug("Executing token key retrieval GET request to {} with headers: {} ", (Object)tokenKeysEndpointUri, (Object)request.getAllHeaders());
        try {
            return (String)this.httpClient.execute((HttpUriRequest)request, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                LOGGER.debug("Received statusCode {}", (Object)statusCode);
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                if (statusCode != 200) {
                    throw OAuth2ServiceException.builder("Error retrieving token keys for x-zone_uuid " + zoneId).withUri(tokenKeysEndpointUri).withHeaders("x-zone_uuid=" + zoneId).withStatusCode(statusCode).withResponseBody(body).build();
                }
                LOGGER.debug("Successfully retrieved token keys from {} for zone '{}'", (Object)tokenKeysEndpointUri, (Object)zoneId);
                return body;
            });
        }
        catch (IOException e) {
            throw new OAuth2ServiceException("Error retrieving token keys: " + e.getMessage());
        }
    }
}

