/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.servlet.MDCHelper;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.AbstractOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.http.HttpHeader;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenService
extends AbstractOAuth2TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2TokenService.class);
    private final CloseableHttpClient httpClient;

    public DefaultOAuth2TokenService(@Nonnull CloseableHttpClient httpClient) {
        this(httpClient, TokenCacheConfiguration.defaultConfiguration());
    }

    public DefaultOAuth2TokenService(@Nonnull CloseableHttpClient httpClient, @Nonnull TokenCacheConfiguration tokenCacheConfiguration) {
        super(tokenCacheConfiguration);
        Assertions.assertNotNull(httpClient, "http client is required");
        this.httpClient = httpClient;
    }

    @Override
    protected OAuth2TokenResponse requestAccessToken(URI tokenEndpointUri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        HttpHeaders requestHeaders = new HttpHeaders(new HttpHeader[0]);
        headers.getHeaders().forEach(h -> requestHeaders.withHeader(h.getName(), h.getValue()));
        requestHeaders.withHeader("X-CorrelationID", MDCHelper.getOrCreateCorrelationId());
        HttpPost httpPost = this.createHttpPost(tokenEndpointUri, requestHeaders, parameters);
        LOGGER.debug("access token request {} - {}", (Object)headers, parameters.entrySet().stream().map(e -> {
            if (((String)e.getKey()).contains("password") || ((String)e.getKey()).contains("client_secret") || ((String)e.getKey()).contains("assertion")) {
                return new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), "****");
            }
            return e;
        }).toList());
        try {
            return this.executeRequest(httpPost);
        }
        catch (IOException | URISyntaxException e2) {
            if (e2 instanceof OAuth2ServiceException) {
                throw (OAuth2ServiceException)e2;
            }
            throw new OAuth2ServiceException("Unexpected error retrieving JWT token: " + e2.getMessage());
        }
    }

    private OAuth2TokenResponse executeRequest(HttpPost httpPost) throws IOException, URISyntaxException {
        httpPost.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        URI requestUri = httpPost.getURI();
        LOGGER.debug("Requesting access token from url {} with headers {}", (Object)requestUri, (Object)httpPost.getAllHeaders());
        String responseBody = (String)this.httpClient.execute((HttpUriRequest)httpPost, response -> {
            int statusCode = response.getStatusLine().getStatusCode();
            LOGGER.debug("Received statusCode {}", (Object)statusCode);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (statusCode != 200) {
                LOGGER.debug("Received response body: {}", (Object)body);
                throw OAuth2ServiceException.builder("Error retrieving JWT token").withStatusCode(statusCode).withUri(requestUri).withResponseBody(body).build();
            }
            return body;
        });
        return this.convertToOAuth2TokenResponse(responseBody);
    }

    private OAuth2TokenResponse convertToOAuth2TokenResponse(String responseBody) throws OAuth2ServiceException {
        Map accessTokenMap = new JSONObject(responseBody).toMap();
        String accessToken = this.getParameter(accessTokenMap, "access_token");
        String refreshToken = this.getParameter(accessTokenMap, "refresh_token");
        String expiresIn = this.getParameter(accessTokenMap, "expires_in");
        String tokenType = this.getParameter(accessTokenMap, "token_type");
        return new OAuth2TokenResponse(accessToken, this.convertExpiresInToLong(expiresIn), refreshToken, tokenType);
    }

    private Long convertExpiresInToLong(String expiresIn) throws OAuth2ServiceException {
        try {
            return Long.parseLong(expiresIn);
        }
        catch (NumberFormatException e) {
            throw new OAuth2ServiceException(String.format("Cannot convert expires_in from response (%s) to long", expiresIn));
        }
    }

    private String getParameter(Map<String, Object> accessTokenMap, String key) {
        return String.valueOf(accessTokenMap.get(key));
    }

    private HttpPost createHttpPost(URI uri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        HttpPost httpPost = new HttpPost(uri);
        headers.getHeaders().forEach(header -> httpPost.setHeader(header.getName(), header.getValue()));
        List<BasicNameValuePair> basicNameValuePairs = parameters.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).toList();
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(basicNameValuePairs));
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2ServiceException("Unexpected error parsing URI: " + e.getMessage());
        }
        return httpPost;
    }
}

