/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class DefaultOidcConfigurationService
implements OidcConfigurationService {
    private final CloseableHttpClient httpClient;

    public DefaultOidcConfigurationService() {
        this.httpClient = HttpClientFactory.create(null);
    }

    public DefaultOidcConfigurationService(CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    public static URI getDiscoveryEndpointUri(@Nonnull String issuerUri) {
        URI uri = URI.create((String)(issuerUri.startsWith("http") ? issuerUri : "https://" + issuerUri));
        return UriUtil.expandPath(uri, "/.well-known/openid-configuration");
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        String endpointsJson;
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        HttpGet request = new HttpGet(discoveryEndpointUri);
        request.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        try {
            endpointsJson = (String)this.httpClient.execute((HttpUriRequest)request, response -> {
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withStatusCode(statusCode).withResponseBody(body).build();
                }
                return body;
            });
        }
        catch (IOException e) {
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints: " + e.getMessage()).withUri(discoveryEndpointUri).build();
        }
        return new OidcEndpointsProvider(endpointsJson);
    }

    static class OidcEndpointsProvider
    implements OAuth2ServiceEndpointsProvider {
        static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        static final String TOKEN_ENDPOINT = "token_endpoint";
        static final String JWKS_ENDPOINT = "jwks_uri";
        private final JSONObject jsonObject;

        OidcEndpointsProvider(String jsonString) {
            this.jsonObject = new JSONObject(jsonString);
        }

        @Override
        public URI getTokenEndpoint() {
            return URI.create(this.jsonObject.getString(TOKEN_ENDPOINT));
        }

        @Override
        public URI getAuthorizeEndpoint() {
            return URI.create(this.jsonObject.getString(AUTHORIZATION_ENDPOINT));
        }

        @Override
        public URI getJwksUri() {
            return URI.create(this.jsonObject.getString(JWKS_ENDPOINT));
        }
    }
}

