/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OAuth2ServiceException
extends IOException {
    private static final long serialVersionUID = 1L;
    private Integer httpStatusCode = 0;

    public OAuth2ServiceException(String message) {
        super(message);
    }

    public OAuth2ServiceException(String message, Integer httpStatusCode) {
        super(message);
        this.httpStatusCode = httpStatusCode != null ? httpStatusCode : 0;
    }

    public static Builder builder(String message) {
        return new Builder(message);
    }

    public static class Builder {
        private final String message;
        private Integer httpStatusCode;
        private URI serverUri;
        private String responseBody;
        private String headers;

        public Builder(String message) {
            this.message = message;
        }

        public Builder withStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            return this;
        }

        public Builder withUri(URI serverUri) {
            this.serverUri = serverUri;
            return this;
        }

        public Builder withResponseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public Builder withHeaders(String ... headers) {
            this.headers = "[";
            for (String header : headers) {
                this.headers = this.headers + header;
            }
            this.headers = this.headers + "]";
            return this;
        }

        public OAuth2ServiceException build() {
            String message = Stream.of(this.message, this.createUriMessage(), this.createStatusCodeMessage(), this.createResponseBodyMessage(), this.createHeaderMessage()).filter(Objects::nonNull).collect(Collectors.joining(". "));
            return new OAuth2ServiceException(message, this.httpStatusCode);
        }

        private String createResponseBodyMessage() {
            return this.responseBody == null ? null : "Response body '" + this.responseBody + "'";
        }

        private String createStatusCodeMessage() {
            return this.httpStatusCode == null ? null : "Http status code " + this.httpStatusCode;
        }

        private String createUriMessage() {
            return this.serverUri == null ? null : "Server URI " + this.serverUri;
        }

        private String createHeaderMessage() {
            return this.headers == null ? null : "Headers " + this.headers;
        }
    }
}

