/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class JwtBearerTokenFlow {
    private final OAuth2TokenService tokenService;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;
    private final ClientIdentity clientIdentity;
    private final Map<String, String> optionalParameters = new HashMap<String, String>();
    private String bearerToken;
    private String xZid;
    private List<String> scopes = new ArrayList<String>();
    private String subdomain;
    private boolean disableCache;

    public JwtBearerTokenFlow(@Nonnull OAuth2TokenService tokenService, @Nonnull OAuth2ServiceEndpointsProvider endpointsProvider, @Nonnull ClientIdentity clientIdentity) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null!");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null!");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null!");
        this.tokenService = tokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientIdentity = clientIdentity;
    }

    public JwtBearerTokenFlow token(@Nonnull String bearerToken) {
        Assertions.assertNotNull(bearerToken, "Bearer token must not be null.");
        this.bearerToken = bearerToken;
        return this;
    }

    public JwtBearerTokenFlow token(@Nonnull Token token) {
        Assertions.assertNotNull(token, "Token must not be null.");
        this.bearerToken = token.getTokenValue();
        this.xZid = token.getZoneId();
        return this;
    }

    public JwtBearerTokenFlow zoneId(String zoneId) {
        this.xZid = zoneId;
        return this;
    }

    public JwtBearerTokenFlow scopes(String ... scopes) {
        Assertions.assertNotNull(scopes, "Scopes must not be null!");
        this.scopes = Arrays.asList(scopes);
        return this;
    }

    public JwtBearerTokenFlow subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    public JwtBearerTokenFlow attributes(Map<String, String> additionalAuthorizationAttributes) {
        this.optionalParameters.put("authorities", XsuaaTokenFlowsUtils.buildAdditionalAuthoritiesJson(additionalAuthorizationAttributes));
        return this;
    }

    public JwtBearerTokenFlow disableCache(boolean disableCache) {
        this.disableCache = disableCache;
        return this;
    }

    public OAuth2TokenResponse execute() throws TokenFlowException {
        if (this.bearerToken == null) {
            throw new IllegalStateException("A bearer token must be set before executing the flow");
        }
        String scopesParameter = String.join((CharSequence)" ", this.scopes);
        if (!scopesParameter.isEmpty()) {
            this.optionalParameters.put("scope", scopesParameter);
        }
        try {
            if (this.xZid == null) {
                return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(this.endpointsProvider.getTokenEndpoint(), this.clientIdentity, this.bearerToken, this.subdomain, this.optionalParameters, this.disableCache);
            }
            return this.tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(this.endpointsProvider.getTokenEndpoint(), this.clientIdentity, this.bearerToken, this.optionalParameters, this.disableCache, this.xZid);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error requesting user token with grant_type '%s': %s", "urn:ietf:params:oauth:grant-type:jwt-bearer", e.getMessage()), e);
        }
    }
}

