/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.config.ClientIdentity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class RequestParameterBuilder {
    private final Map<String, String> parameters = new HashMap<String, String>();

    RequestParameterBuilder() {
    }

    public RequestParameterBuilder withGrantType(String grantType) {
        this.parameters.put("grant_type", grantType);
        return this;
    }

    public RequestParameterBuilder withClientId(String clientId) {
        this.parameters.put("client_id", clientId);
        return this;
    }

    public RequestParameterBuilder withRefreshToken(String refreshToken) {
        this.parameters.put("refresh_token", refreshToken);
        return this;
    }

    public RequestParameterBuilder withClientIdentity(ClientIdentity clientIdentity) {
        this.parameters.put("client_id", clientIdentity.getId());
        if (clientIdentity.isCertificateBased()) {
            return this;
        }
        this.parameters.put("client_secret", clientIdentity.getSecret());
        return this;
    }

    public RequestParameterBuilder withOptionalParameters(Map<String, String> optionalParameters) {
        Optional.ofNullable(optionalParameters).orElse(Collections.emptyMap()).forEach(this.parameters::putIfAbsent);
        return this;
    }

    public RequestParameterBuilder withUsername(String username) {
        this.parameters.put("username", username);
        return this;
    }

    public RequestParameterBuilder withPassword(String password) {
        this.parameters.put("password", password);
        return this;
    }

    public RequestParameterBuilder withToken(String token) {
        this.parameters.put("assertion", token);
        return this;
    }

    public Map<String, String> buildAsMap() {
        return this.parameters;
    }
}

