/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.http;

import com.sap.cloud.security.xsuaa.http.HttpHeader;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.http.MediaType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpHeadersFactory {
    private HttpHeadersFactory() {
    }

    public static HttpHeaders createWithAuthorizationBearerHeader(String token) {
        Map<String, String> headers = HttpHeadersFactory.createDefaultHeaders();
        String AUTHORIZATION_BEARER_TOKEN_FORMAT = "Bearer %s";
        headers.put("Authorization", String.format("Bearer %s", token));
        return HttpHeadersFactory.createFromHeaders(headers);
    }

    public static HttpHeaders createWithoutAuthorizationHeader() {
        return HttpHeadersFactory.createFromHeaders(HttpHeadersFactory.createDefaultHeaders());
    }

    private static HttpHeaders createFromHeaders(Map<String, String> headers) {
        List<HttpHeader> httpHeaders = headers.entrySet().stream().map(header -> new HttpHeader((String)header.getKey(), (String)header.getValue())).collect(Collectors.toList());
        return new HttpHeaders(httpHeaders);
    }

    private static Map<String, String> createDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", MediaType.APPLICATION_JSON.value());
        headers.put("Content-Type", MediaType.APPLICATION_FORM_URLENCODED.value());
        return headers;
    }
}

