/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.client;

import com.sap.cloud.security.client.HttpClientException;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final int DEFAULT_SOCKET_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int MAX_CONNECTIONS = 200;
    private final ConcurrentHashMap<String, SslConnection> sslConnectionPool = new ConcurrentHashMap();
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(DEFAULT_TIMEOUT).setConnectionRequestTimeout(DEFAULT_TIMEOUT).setSocketTimeout(DEFAULT_SOCKET_TIMEOUT).setRedirectsEnabled(false).build();

    @Override
    public CloseableHttpClient createClient(ClientIdentity clientIdentity) throws HttpClientException {
        String clientId = clientIdentity != null ? clientIdentity.getId() : null;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(this.requestConfig);
        if (clientId != null && clientIdentity.isCertificateBased()) {
            SslConnection connectionPool = this.sslConnectionPool.compute(clientId, (s, c) -> new SslConnection(clientIdentity));
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionPool.poolingConnectionManager).setSSLContext(connectionPool.context).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionPool.sslSocketFactory).build();
        }
        return httpClientBuilder.build();
    }

    private static class SslConnection {
        SSLContext context;
        SSLConnectionSocketFactory sslSocketFactory;
        PoolingHttpClientConnectionManager poolingConnectionManager;

        public SslConnection(ClientIdentity clientIdentity) {
            try {
                this.context = SSLContextFactory.getInstance().create(clientIdentity);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientException(String.format("Couldn't set up https client for service provider %s. %s.", clientIdentity.getId(), e.getLocalizedMessage()));
            }
            this.sslSocketFactory = new SSLConnectionSocketFactory(this.context);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.sslSocketFactory).build();
            this.poolingConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            this.poolingConnectionManager.setDefaultMaxPerRoute(20);
            this.poolingConnectionManager.setMaxTotal(200);
        }
    }
}

