/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OAuth2ServiceException
extends IOException {
    private static final long serialVersionUID = 1L;
    private Integer httpStatusCode = 0;
    private final List<String> headers = new ArrayList<String>();

    public OAuth2ServiceException(String message) {
        super(message);
    }

    public OAuth2ServiceException(String message, Integer httpStatusCode) {
        super(message);
        this.httpStatusCode = httpStatusCode != null ? httpStatusCode : 0;
    }

    OAuth2ServiceException(String message, Integer httpStatusCode, List<String> headers) {
        this(message, httpStatusCode);
        this.headers.addAll(headers);
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public static Builder builder(String message) {
        return new Builder(message);
    }

    public static class Builder {
        private final String message;
        private Integer httpStatusCode;
        private URI serverUri;
        private String responseBody;
        private final List<String> headers = new ArrayList<String>();
        private String headersString;

        public Builder(String message) {
            this.message = message;
        }

        public Builder withStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            return this;
        }

        public Builder withUri(URI serverUri) {
            this.serverUri = serverUri;
            return this;
        }

        public Builder withResponseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public Builder withHeaders(String ... headers) {
            List<String> headerList = Arrays.stream(headers).filter(Objects::nonNull).toList();
            this.headers.addAll(headerList);
            this.headersString = headerList.stream().collect(Collectors.joining(", ", "[", "]"));
            return this;
        }

        public OAuth2ServiceException build() {
            String m = Stream.of(this.message, this.createUriMessage(), this.createStatusCodeMessage(), this.createResponseBodyMessage(), this.createHeaderMessage()).filter(Objects::nonNull).collect(Collectors.joining(". "));
            return new OAuth2ServiceException(m, this.httpStatusCode, this.headers);
        }

        private String createResponseBodyMessage() {
            return this.responseBody == null ? null : "Response body '" + this.responseBody + "'";
        }

        private String createStatusCodeMessage() {
            return this.httpStatusCode == null ? null : "Http status code " + this.httpStatusCode;
        }

        private String createUriMessage() {
            return this.serverUri == null ? null : "Server URI " + this.serverUri;
        }

        private String createHeaderMessage() {
            return this.headersString == null ? null : "Response Headers " + this.headersString;
        }
    }
}

