/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2TokenKeyService.class);
    private final CloseableHttpClient httpClient;

    public DefaultOAuth2TokenKeyService() {
        this.httpClient = HttpClientFactory.create(null);
    }

    public DefaultOAuth2TokenKeyService(@Nonnull CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
    }

    @Override
    public String retrieveTokenKeys(@Nonnull URI tokenKeysEndpointUri, Map<String, String> params) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        HttpGet request = new HttpGet(tokenKeysEndpointUri);
        for (Map.Entry<String, String> p : params.entrySet()) {
            request.addHeader(p.getKey(), p.getValue());
        }
        request.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        LOGGER.debug("Executing token key retrieval GET request to {} with headers: {} ", (Object)tokenKeysEndpointUri, (Object)request.getAllHeaders());
        try {
            return (String)this.httpClient.execute((HttpUriRequest)request, arg_0 -> DefaultOAuth2TokenKeyService.lambda$retrieveTokenKeys$1((HttpUriRequest)request, tokenKeysEndpointUri, params, arg_0));
        }
        catch (IOException e) {
            if (e instanceof OAuth2ServiceException) {
                OAuth2ServiceException oAuth2Exception = (OAuth2ServiceException)e;
                throw oAuth2Exception;
            }
            throw new OAuth2ServiceException("Error retrieving token keys: " + e.getMessage());
        }
    }

    private static /* synthetic */ String lambda$retrieveTokenKeys$1(HttpUriRequest request, URI tokenKeysEndpointUri, Map params, HttpResponse response) throws ClientProtocolException, IOException {
        String xOsbPlan;
        int statusCode = response.getStatusLine().getStatusCode();
        LOGGER.debug("Received statusCode {}", (Object)statusCode);
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        if (statusCode != 200) {
            throw OAuth2ServiceException.builder("Error retrieving token keys. Request headers " + String.valueOf(Arrays.stream(request.getAllHeaders()).toList())).withUri(tokenKeysEndpointUri).withHeaders(response.getAllHeaders() != null ? (String[])Arrays.stream(response.getAllHeaders()).map(Header::toString).toArray(String[]::new) : null).withStatusCode(statusCode).withResponseBody(body).build();
        }
        LOGGER.debug("Successfully retrieved token keys from {} with params {}.", (Object)tokenKeysEndpointUri, (Object)params);
        if (response.containsHeader("x-osb_plan") && (xOsbPlan = response.getFirstHeader("x-osb_plan").getValue()) != null) {
            SecurityContext.setServicePlans((String)xOsbPlan);
        }
        return body;
    }
}

