/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.mtls;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.MinimalDERParser;
import com.sap.cloud.security.xsuaa.Assertions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextFactory {
    private static final char[] noPassword = "".toCharArray();
    private static final SSLContextFactory instance = new SSLContextFactory();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private SSLContextFactory() {
    }

    public static SSLContextFactory getInstance() {
        return instance;
    }

    private static String removeHeaders(String privateKey) {
        return privateKey.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\\n", "").replace("\n", "").replace("\\r", "").replace("\r", "");
    }

    public SSLContext create(String x509Certificates, String privateKey) throws GeneralSecurityException, IOException {
        Assertions.assertHasText(x509Certificates, "x509Certificate is required");
        Assertions.assertHasText(privateKey, "privateKey is required");
        return this.create((ClientIdentity)new ClientCertificate(x509Certificates, privateKey, null));
    }

    public SSLContext create(ClientIdentity clientIdentity) throws GeneralSecurityException, IOException {
        KeyStore keystore = this.createKeyStore(clientIdentity);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keystore, noPassword);
        SSLContext sslContext = this.createDefaultSSLContext();
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sslContext;
    }

    private KeyStore initializeKeyStore(PrivateKey privateKey, Certificate[] certificateChain) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(null);
        int i = 0;
        for (Certificate certificate : certificateChain) {
            keystore.setCertificateEntry("cert-alias-" + i++, certificate);
        }
        keystore.setKeyEntry("key-alias", privateKey, noPassword, certificateChain);
        return keystore;
    }

    private SSLContext createDefaultSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance("TLS");
    }

    public KeyStore createKeyStore(ClientIdentity clientIdentity) throws GeneralSecurityException, IOException {
        Assertions.assertNotNull(clientIdentity, "clientIdentity must not be null");
        try {
            Assertions.assertHasText(clientIdentity.getCertificate(), "clientIdentity.getCertificate() must not return null");
            Assertions.assertHasText(clientIdentity.getKey(), "clientIdentity.getKey() must not return null");
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("clientIdentity.getCertificate() or clientIdentity.getKey() is null. Trying to use certificateChain and privateKey instead.");
            Assertions.assertNotNull(clientIdentity.getCertificateChain(), e.getMessage() + " or clientIdentity.getCertificateChain() must not return null");
            Assertions.assertNotNull(clientIdentity.getPrivateKey(), e.getMessage() + " or clientIdentity.getKey() or clientIdentity.getPrivateKey() must not return null");
        }
        Certificate[] certificateChain = this.getCertificateChain(clientIdentity);
        PrivateKey privateKey = this.getPrivateKey(clientIdentity);
        return this.initializeKeyStore(privateKey, certificateChain);
    }

    private PrivateKey getPrivateKey(ClientIdentity clientIdentity) throws GeneralSecurityException {
        KeySpec keySpec = null;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        String pemPrivateKey = clientIdentity.getKey();
        PrivateKey privateKey = clientIdentity.getPrivateKey();
        if (pemPrivateKey != null) {
            if (pemPrivateKey.startsWith("-----BEGIN RSA PRIVATE")) {
                keySpec = this.parsePKCS1PrivateKey(Base64.getDecoder().decode(SSLContextFactory.removeHeaders(pemPrivateKey)));
            } else {
                keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(SSLContextFactory.removeHeaders(pemPrivateKey)));
                keyFactory = KeyFactory.getInstance("EC");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PEM private key: '{}...{}'", (Object)pemPrivateKey.substring(5, 40), (Object)pemPrivateKey.substring(pemPrivateKey.length() - 25));
            }
        } else if (privateKey != null && privateKey.getAlgorithm().equals("EC")) {
            keyFactory = KeyFactory.getInstance("EC");
            keySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        }
        this.logger.debug("Private key encoding algorithm: {}", (Object)keyFactory.getAlgorithm());
        return keyFactory.generatePrivate(keySpec);
    }

    private Certificate[] getCertificateChain(ClientIdentity clientIdentity) throws CertificateException {
        String certificates = clientIdentity.getCertificate();
        Certificate[] certificateChain = null;
        if (clientIdentity.getCertificate() != null) {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            byte[] certificatesBytes = certificates.replace("\\n", "\n").getBytes();
            Collection<? extends Certificate> certificateList = factory.generateCertificates(new ByteArrayInputStream(certificatesBytes));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PEM Certificate: '{}...{}'", (Object)certificates.substring(5, 40), (Object)certificates.substring(certificates.length() - 25));
            }
            certificateChain = certificateList.toArray(new Certificate[0]);
        } else if (clientIdentity.getCertificateChain() != null) {
            certificateChain = clientIdentity.getCertificateChain();
        }
        return certificateChain;
    }

    private KeySpec parsePKCS1PrivateKey(byte[] privateKeyDerEncoded) throws GeneralSecurityException {
        RSAPrivateCrtKeySpec keySpec;
        MinimalDERParser parser = new MinimalDERParser(privateKeyDerEncoded);
        try {
            parser.getSequence();
            BigInteger version = parser.getBigInteger();
            if (!version.equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Only version 0 supported for PKCS1 decoding.");
            }
            BigInteger modulus = parser.getBigInteger();
            BigInteger publicExponent = parser.getBigInteger();
            BigInteger privateExponent = parser.getBigInteger();
            BigInteger primeP = parser.getBigInteger();
            BigInteger primeQ = parser.getBigInteger();
            BigInteger primeExponentP = parser.getBigInteger();
            BigInteger primeExponentQ = parser.getBigInteger();
            BigInteger crtCoefficient = parser.getBigInteger();
            keySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Exception during parsing DER encoded private key", e);
        }
        return keySpec;
    }
}

