/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;

public class SpringOidcConfigurationService
implements OidcConfigurationService {
    private final RestOperations restOperations;

    public SpringOidcConfigurationService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("User-Agent", HttpClientUtil.getUserAgent());
            ResponseEntity response = this.restOperations.exchange(discoveryEndpointUri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class);
            if (HttpStatus.OK.value() == response.getStatusCode().value()) {
                return new DefaultOidcConfigurationService.OidcEndpointsProvider((String)response.getBody());
            }
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withStatusCode(response.getStatusCodeValue()).withResponseBody((String)response.getBody()).build();
        }
        catch (HttpClientErrorException ex) {
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withStatusCode(ex.getStatusCode().value()).withResponseBody(ex.getResponseBodyAsString()).build();
        }
    }
}

