/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private static final String SUCCESS_MESSAGE = "Successfully retrieved token keys from {} with params {}.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2TokenKeyService.class);
    private final CloseableHttpClient httpClient;
    private final DefaultTokenClientConfiguration config;

    public DefaultOAuth2TokenKeyService() {
        this.httpClient = HttpClientFactory.create(null);
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    public DefaultOAuth2TokenKeyService(@Nonnull CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    @Override
    public String retrieveTokenKeys(@Nonnull URI tokenKeysEndpointUri, Map<String, String> params) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        return this.executeRequest(tokenKeysEndpointUri, params, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0);
    }

    private String executeRequest(URI tokenKeysEndpointUri, Map<String, String> params, int attemptsLeft) throws OAuth2ServiceException {
        HttpUriRequest httpUriRequest = this.getHttpUriRequest(tokenKeysEndpointUri, params);
        LOGGER.debug("Executing token key retrieval GET request to {} with headers: {} and {} retries left", new Object[]{tokenKeysEndpointUri, httpUriRequest.getAllHeaders(), attemptsLeft});
        try {
            return (String)this.httpClient.execute(httpUriRequest, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                LOGGER.debug("Received statusCode {} from {}", (Object)statusCode, (Object)tokenKeysEndpointUri);
                if (200 == statusCode) {
                    LOGGER.debug(SUCCESS_MESSAGE, (Object)tokenKeysEndpointUri, (Object)params);
                    this.handleServicePlanFromResponse(response);
                    return body;
                }
                if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                    LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                    this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                    return this.executeRequest(tokenKeysEndpointUri, params, attemptsLeft - 1);
                }
                throw OAuth2ServiceException.builder("Error retrieving token keys.").withUri(tokenKeysEndpointUri).withResponseHeaders(DefaultOAuth2TokenKeyService.getHeadersAsStringArray(response.getAllHeaders())).withRequestHeaders(DefaultOAuth2TokenKeyService.getHeadersAsStringArray(httpUriRequest.getAllHeaders())).withStatusCode(statusCode).withResponseBody(body).build();
            });
        }
        catch (IOException e) {
            if (e instanceof OAuth2ServiceException) {
                OAuth2ServiceException oAuth2Exception = (OAuth2ServiceException)e;
                throw oAuth2Exception;
            }
            throw OAuth2ServiceException.builder("Error retrieving token keys: " + e.getMessage()).withUri(tokenKeysEndpointUri).withRequestHeaders(DefaultOAuth2TokenKeyService.getHeadersAsStringArray(httpUriRequest.getAllHeaders())).withResponseBody(e.getMessage()).build();
        }
    }

    private HttpUriRequest getHttpUriRequest(URI tokenKeysEndpointUri, Map<String, String> params) {
        HttpGet request = new HttpGet(tokenKeysEndpointUri);
        for (Map.Entry<String, String> p : params.entrySet()) {
            request.addHeader(p.getKey(), p.getValue());
        }
        request.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        return request;
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }

    private void handleServicePlanFromResponse(HttpResponse response) {
        String xOsbPlan;
        if (response.containsHeader("x-osb_plan") && (xOsbPlan = response.getFirstHeader("x-osb_plan").getValue()) != null) {
            SecurityContext.setServicePlans((String)xOsbPlan);
        }
    }

    private static String[] getHeadersAsStringArray(Header[] headers) {
        return headers != null ? (String[])Arrays.stream(headers).map(Header::toString).toArray(String[]::new) : new String[]{};
    }
}

