/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.servlet.MDCHelper;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.AbstractOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.http.HttpHeader;
import com.sap.cloud.security.xsuaa.http.HttpHeaders;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth2TokenService
extends AbstractOAuth2TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth2TokenService.class);
    private final CloseableHttpClient httpClient;
    private final DefaultTokenClientConfiguration config = DefaultTokenClientConfiguration.getInstance();

    public DefaultOAuth2TokenService(@Nonnull CloseableHttpClient httpClient) {
        this(httpClient, TokenCacheConfiguration.defaultConfiguration());
    }

    public DefaultOAuth2TokenService(@Nonnull CloseableHttpClient httpClient, @Nonnull TokenCacheConfiguration tokenCacheConfiguration) {
        super(tokenCacheConfiguration);
        Assertions.assertNotNull(httpClient, "http client is required");
        this.httpClient = httpClient;
    }

    @Override
    protected OAuth2TokenResponse requestAccessToken(URI tokenUri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenUri, "Token endpoint URI must not be null!");
        return this.convertToOAuth2TokenResponse(this.executeRequest(tokenUri, headers, parameters, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0));
    }

    private String executeRequest(URI tokenUri, HttpHeaders headers, Map<String, String> parameters, int attemptsLeft) throws OAuth2ServiceException {
        HttpPost httpPost = this.createHttpPost(tokenUri, this.createRequestHeaders(headers), parameters);
        LOGGER.debug("Requesting access token from url {} with headers {} and {} retries left", new Object[]{tokenUri, headers, attemptsLeft});
        try {
            return (String)this.httpClient.execute((HttpUriRequest)httpPost, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                LOGGER.debug("Received statusCode {} from {}", (Object)statusCode, (Object)tokenUri);
                if (200 == statusCode) {
                    LOGGER.debug("Successfully retrieved access token from {} with params {}.", (Object)tokenUri, (Object)parameters);
                    return body;
                }
                if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                    LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                    this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                    return this.executeRequest(tokenUri, headers, parameters, attemptsLeft - 1);
                }
                throw OAuth2ServiceException.builder("Error requesting access token!").withStatusCode(statusCode).withUri(tokenUri).withRequestHeaders(DefaultOAuth2TokenService.getHeadersAsStringArray(httpPost.getAllHeaders())).withResponseHeaders(DefaultOAuth2TokenService.getHeadersAsStringArray(response.getAllHeaders())).withResponseBody(body).build();
            });
        }
        catch (IOException e) {
            if (e instanceof OAuth2ServiceException) {
                OAuth2ServiceException oAuth2Exception = (OAuth2ServiceException)e;
                throw oAuth2Exception;
            }
            throw OAuth2ServiceException.builder("Error requesting access token!").withUri(tokenUri).withRequestHeaders(DefaultOAuth2TokenService.getHeadersAsStringArray(httpPost.getAllHeaders())).withResponseBody(e.getMessage()).build();
        }
    }

    private HttpHeaders createRequestHeaders(HttpHeaders headers) {
        HttpHeaders requestHeaders = new HttpHeaders(new HttpHeader[0]);
        headers.getHeaders().forEach(h -> requestHeaders.withHeader(h.getName(), h.getValue()));
        requestHeaders.withHeader("X-CorrelationID", MDCHelper.getOrCreateCorrelationId());
        return requestHeaders;
    }

    private void logRequest(HttpHeaders headers, Map<String, String> parameters) {
        LOGGER.debug("access token request {} - {}", (Object)headers, parameters.entrySet().stream().map(e -> {
            if (((String)e.getKey()).contains("password") || ((String)e.getKey()).contains("client_secret") || ((String)e.getKey()).contains("assertion")) {
                return new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), "****");
            }
            return e;
        }).toList());
    }

    private HttpPost createHttpPost(URI uri, HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        HttpPost httpPost = new HttpPost(uri);
        headers.getHeaders().forEach(header -> httpPost.setHeader(header.getName(), header.getValue()));
        List<BasicNameValuePair> basicNameValuePairs = parameters.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).toList();
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(basicNameValuePairs));
            httpPost.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2ServiceException("Unexpected error parsing URI: " + e.getMessage());
        }
        this.logRequest(headers, parameters);
        return httpPost;
    }

    private OAuth2TokenResponse convertToOAuth2TokenResponse(String responseBody) throws OAuth2ServiceException {
        Map accessTokenMap = new JSONObject(responseBody).toMap();
        String accessToken = this.getParameter(accessTokenMap, "access_token");
        String refreshToken = this.getParameter(accessTokenMap, "refresh_token");
        String expiresIn = this.getParameter(accessTokenMap, "expires_in");
        String tokenType = this.getParameter(accessTokenMap, "token_type");
        return new OAuth2TokenResponse(accessToken, this.convertExpiresInToLong(expiresIn), refreshToken, tokenType);
    }

    private Long convertExpiresInToLong(String expiresIn) throws OAuth2ServiceException {
        try {
            return Long.parseLong(expiresIn);
        }
        catch (NumberFormatException e) {
            throw new OAuth2ServiceException(String.format("Cannot convert expires_in from response (%s) to long", expiresIn));
        }
    }

    private String getParameter(Map<String, Object> accessTokenMap, String key) {
        return String.valueOf(accessTokenMap.get(key));
    }

    private static String[] getHeadersAsStringArray(Header[] headers) {
        return headers != null ? (String[])Arrays.stream(headers).map(Header::toString).toArray(String[]::new) : new String[]{};
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }
}

