/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOidcConfigurationService
implements OidcConfigurationService {
    private final CloseableHttpClient httpClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOidcConfigurationService.class);
    private final DefaultTokenClientConfiguration config;

    public DefaultOidcConfigurationService() {
        this.httpClient = HttpClientFactory.create(null);
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    public DefaultOidcConfigurationService(CloseableHttpClient httpClient) {
        Assertions.assertNotNull(httpClient, "httpClient is required");
        this.httpClient = httpClient;
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    public static URI getDiscoveryEndpointUri(@Nonnull String issuerUri) {
        URI uri;
        if (issuerUri.startsWith("http://localhost") || issuerUri.startsWith("https://")) {
            uri = URI.create(issuerUri);
        } else {
            if (issuerUri.startsWith("http://")) {
                return null;
            }
            uri = URI.create("https://" + issuerUri);
        }
        return UriUtil.expandPath(uri, "/.well-known/openid-configuration");
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        String endpointsJson = this.executeRequest(discoveryEndpointUri, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0);
        return new OidcEndpointsProvider(endpointsJson);
    }

    private String executeRequest(URI discoveryEndpointUri, int attemptsLeft) throws OAuth2ServiceException {
        HttpGet httpGet = new HttpGet(discoveryEndpointUri);
        httpGet.addHeader("User-Agent", HttpClientUtil.getUserAgent());
        LOGGER.debug("Retrieving configured oidc endpoints: {} with headers {} and {} retries left", new Object[]{discoveryEndpointUri, httpGet.getAllHeaders(), attemptsLeft});
        try {
            return (String)this.httpClient.execute((HttpUriRequest)httpGet, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                LOGGER.debug("Received statusCode {} from {}", (Object)statusCode, (Object)discoveryEndpointUri);
                if (200 == statusCode) {
                    LOGGER.debug("Successfully retrieved oidc endpoints from {}.", (Object)discoveryEndpointUri);
                    return body;
                }
                if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                    LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                    this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                    return this.executeRequest(discoveryEndpointUri, attemptsLeft - 1);
                }
                throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withStatusCode(statusCode).withUri(discoveryEndpointUri).withRequestHeaders(DefaultOidcConfigurationService.getHeadersAsStringArray(httpGet.getAllHeaders())).withResponseHeaders(DefaultOidcConfigurationService.getHeadersAsStringArray(response.getAllHeaders())).withResponseBody(body).build();
            });
        }
        catch (IOException e) {
            if (e instanceof OAuth2ServiceException) {
                OAuth2ServiceException oAuth2Exception = (OAuth2ServiceException)e;
                throw oAuth2Exception;
            }
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints: " + e.getMessage()).withUri(discoveryEndpointUri).withRequestHeaders(DefaultOidcConfigurationService.getHeadersAsStringArray(httpGet.getAllHeaders())).withResponseBody(e.getMessage()).build();
        }
    }

    private static String[] getHeadersAsStringArray(Header[] headers) {
        return headers != null ? (String[])Arrays.stream(headers).map(Header::toString).toArray(String[]::new) : new String[]{};
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }

    static class OidcEndpointsProvider
    implements OAuth2ServiceEndpointsProvider {
        static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        static final String TOKEN_ENDPOINT = "token_endpoint";
        static final String JWKS_ENDPOINT = "jwks_uri";
        private final JSONObject jsonObject;

        OidcEndpointsProvider(String jsonString) {
            this.jsonObject = new JSONObject(jsonString);
        }

        @Override
        public URI getTokenEndpoint() {
            return URI.create(this.jsonObject.getString(TOKEN_ENDPOINT));
        }

        @Override
        public URI getAuthorizeEndpoint() {
            return URI.create(this.jsonObject.getString(AUTHORIZATION_ENDPOINT));
        }

        @Override
        public URI getJwksUri() {
            return URI.create(this.jsonObject.getString(JWKS_ENDPOINT));
        }
    }
}

