/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenKeyService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

public class SpringOAuth2TokenKeyService
implements OAuth2TokenKeyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringOAuth2TokenKeyService.class);
    private final DefaultTokenClientConfiguration config;
    private final RestOperations restOperations;

    public SpringOAuth2TokenKeyService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    @Override
    public String retrieveTokenKeys(@Nonnull URI tokenKeysEndpointUri, Map<String, String> params) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenKeysEndpointUri, "Token key endpoint must not be null!");
        return this.executeRequest(tokenKeysEndpointUri, params, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0);
    }

    private String executeRequest(URI tokenKeysEndpointUri, Map<String, String> params, int attemptsLeft) throws OAuth2ServiceException {
        HttpHeaders headers = this.getHttpHeaders(params);
        LOGGER.debug("Requesting access token from url='{}' with headers={} and {} retries left", new Object[]{tokenKeysEndpointUri, headers, attemptsLeft});
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(tokenKeysEndpointUri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class);
            int statusCode = responseEntity.getStatusCode().value();
            LOGGER.debug("Received statusCode {}", (Object)statusCode);
            if (HttpStatus.OK.value() == statusCode) {
                LOGGER.debug("Successfully retrieved token keys from {} for params '{}'", (Object)tokenKeysEndpointUri, params);
                return (String)responseEntity.getBody();
            }
            if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                return this.executeRequest(tokenKeysEndpointUri, params, attemptsLeft - 1);
            }
            throw OAuth2ServiceException.builder("Error retrieving token keys.").withUri(tokenKeysEndpointUri).withRequestHeaders(SpringOAuth2TokenKeyService.getHeadersAsStringArray(headers)).withResponseHeaders(SpringOAuth2TokenKeyService.getHeadersAsStringArray(responseEntity.getHeaders())).withStatusCode(responseEntity.getStatusCode().value()).withResponseBody((String)responseEntity.getBody()).build();
        }
        catch (HttpStatusCodeException ex) {
            throw OAuth2ServiceException.builder("Error retrieving token keys.").withUri(tokenKeysEndpointUri).withRequestHeaders(SpringOAuth2TokenKeyService.getHeadersAsStringArray(headers)).withStatusCode(ex.getStatusCode().value()).withResponseBody(ex.getResponseBodyAsString()).build();
        }
        catch (Exception e) {
            if (e instanceof OAuth2ServiceException) {
                OAuth2ServiceException oAuth2ServiceException = (OAuth2ServiceException)e;
                throw oAuth2ServiceException;
            }
            throw OAuth2ServiceException.builder("Unexpected error retrieving token keys!").withUri(tokenKeysEndpointUri).withRequestHeaders(SpringOAuth2TokenKeyService.getHeadersAsStringArray(headers)).withResponseBody(e.getMessage()).build();
        }
    }

    private static String[] getHeadersAsStringArray(HttpHeaders headers) {
        return headers != null ? (String[])headers.entrySet().stream().map(e -> (String)e.getKey() + ": " + String.join((CharSequence)",", (Iterable)e.getValue())).toArray(String[]::new) : new String[]{};
    }

    private HttpHeaders getHttpHeaders(Map<String, String> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("User-Agent", HttpClientUtil.getUserAgent());
        for (Map.Entry<String, String> p : params.entrySet()) {
            headers.set(p.getKey(), p.getValue());
        }
        return headers;
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }
}

