/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;

public class RefreshTokenFlow {
    private final ClientIdentity clientIdentity;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;
    private String refreshToken;
    private final OAuth2TokenService tokenService;
    private boolean disableCache = false;
    private String subdomain;

    RefreshTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientIdentity clientIdentity) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null.");
        this.tokenService = tokenService;
        this.clientIdentity = clientIdentity;
        this.endpointsProvider = endpointsProvider;
    }

    public RefreshTokenFlow subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    public RefreshTokenFlow refreshToken(String refreshToken) {
        Assertions.assertNotNull(refreshToken, "RefreshToken must not be null.");
        this.refreshToken = refreshToken;
        return this;
    }

    public RefreshTokenFlow disableCache(boolean disableCache) {
        this.disableCache = disableCache;
        return this;
    }

    public OAuth2TokenResponse execute() throws IllegalStateException, IllegalArgumentException, TokenFlowException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("Refresh token not set. Make sure to have called the refreshToken() method on RefreshTokenFlow builder.");
        }
        try {
            return this.tokenService.retrieveAccessTokenViaRefreshToken(this.endpointsProvider.getTokenEndpoint(), this.clientIdentity, this.refreshToken, this.subdomain, this.disableCache);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error refreshing token with grant_type 'refresh_token': %s", e.getMessage()), e);
        }
    }
}

