/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.CacheConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TokenCacheConfiguration
implements CacheConfiguration {
    private static final TokenCacheConfiguration DEFAULT = new TokenCacheConfiguration(Duration.ofMinutes(10L), 1000, Duration.ofSeconds(30L), false);
    private static final TokenCacheConfiguration CACHE_DISABLED = new DisabledCache();
    private final Duration cacheDuration;
    private final int cacheSize;
    private final Duration tokenExpirationDelta;
    private final boolean cacheStatisticsEnabled;

    public static TokenCacheConfiguration getInstance(@Nonnull Duration cacheDuration, int cacheSize, @Nonnull Duration tokenExpirationDelta) {
        Assertions.assertNotNull(cacheDuration, "The cache duration write must not be null!");
        return new TokenCacheConfiguration(cacheDuration, cacheSize, tokenExpirationDelta, false);
    }

    public static TokenCacheConfiguration getInstance(Duration cacheDuration, int cacheSize, Duration tokenExpirationDelta, boolean cacheStatisticsEnabled) {
        return new TokenCacheConfiguration(cacheDuration, cacheSize, tokenExpirationDelta, cacheStatisticsEnabled);
    }

    public static TokenCacheConfiguration cacheDisabled() {
        return CACHE_DISABLED;
    }

    public static TokenCacheConfiguration defaultConfiguration() {
        return DEFAULT;
    }

    private TokenCacheConfiguration(Duration cacheDuration, int cacheSize, Duration tokenExpirationDelta, boolean cacheStatisticsEnabled) {
        this.cacheDuration = cacheDuration;
        this.cacheSize = cacheSize;
        this.tokenExpirationDelta = tokenExpirationDelta;
        this.cacheStatisticsEnabled = cacheStatisticsEnabled;
    }

    @Nonnull
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public Duration getTokenExpirationDelta() {
        return this.tokenExpirationDelta;
    }

    public boolean isCacheStatisticsEnabled() {
        return this.cacheStatisticsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenCacheConfiguration that = (TokenCacheConfiguration)o;
        return this.cacheSize == that.cacheSize && Objects.equals(this.cacheDuration, that.cacheDuration);
    }

    public int hashCode() {
        return Objects.hash(this.cacheDuration, this.cacheSize);
    }

    public String toString() {
        return "TokenCacheConfiguration{cacheDuration=" + String.valueOf(this.cacheDuration) + ", cacheSize=" + this.cacheSize + ", tokenExpirationDelta=" + String.valueOf(this.tokenExpirationDelta) + "}";
    }

    private static class DisabledCache
    extends TokenCacheConfiguration {
        private DisabledCache() {
            super(Duration.ZERO, 0, Duration.ZERO, false);
        }

        public boolean isCacheDisabled() {
            return true;
        }
    }
}

