/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.client;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTokenClientConfiguration {
    private static volatile DefaultTokenClientConfiguration instance;
    private boolean isRetryEnabled = false;
    private int maxRetryAttempts = 3;
    private long retryDelayTime = 1000L;
    private Set<Integer> retryStatusCodes = Set.of(Integer.valueOf(408), Integer.valueOf(429), Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
    private static final Logger LOGGER;

    private DefaultTokenClientConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultTokenClientConfiguration getInstance() {
        if (instance != null) return instance;
        Class<DefaultTokenClientConfiguration> clazz = DefaultTokenClientConfiguration.class;
        synchronized (DefaultTokenClientConfiguration.class) {
            if (instance != null) return instance;
            instance = new DefaultTokenClientConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(DefaultTokenClientConfiguration newInstance) {
        Class<DefaultTokenClientConfiguration> clazz = DefaultTokenClientConfiguration.class;
        synchronized (DefaultTokenClientConfiguration.class) {
            instance = newInstance;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isRetryEnabled() {
        return this.isRetryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.isRetryEnabled = retryEnabled;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public long getRetryDelayTime() {
        return this.retryDelayTime;
    }

    public void setRetryDelayTime(long retryDelayTime) {
        this.retryDelayTime = retryDelayTime;
    }

    public Set<Integer> getRetryStatusCodes() {
        return this.retryStatusCodes;
    }

    public void setRetryStatusCodes(Set<Integer> retryStatusCodes) {
        this.retryStatusCodes = retryStatusCodes;
    }

    public void setRetryStatusCodes(String retryStatusCodes) {
        try {
            this.setRetryStatusCodes(this.parseRetryStatusCodes(retryStatusCodes));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Failed to parse retry status codes: {}", (Object)retryStatusCodes, (Object)e);
            throw new IllegalStateException("Failed to parse retry status codes: " + retryStatusCodes, e);
        }
    }

    private Set<Integer> parseRetryStatusCodes(String retryStatusCodes) {
        return Arrays.stream(Optional.ofNullable(retryStatusCodes).orElse("").split(",")).map(String::trim).filter(s -> !s.isBlank()).map(Integer::parseInt).collect(Collectors.toSet());
    }

    public String toString() {
        return "DefaultTokenClientConfig{isRetryEnabled=" + this.isRetryEnabled + ", maxRetryAttempts=" + this.maxRetryAttempts + ", retryDelayTime=" + this.retryDelayTime + ", retryStatusCodes='" + String.valueOf(this.retryStatusCodes) + "'}";
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefaultTokenClientConfiguration.class);
    }
}

