/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.DefaultOidcConfigurationService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OidcConfigurationService;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;

public class SpringOidcConfigurationService
implements OidcConfigurationService {
    private final RestOperations restOperations;
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringOidcConfigurationService.class);
    private final DefaultTokenClientConfiguration config;

    public SpringOidcConfigurationService(@Nonnull RestOperations restOperations) {
        Assertions.assertNotNull(restOperations, "restOperations must not be null!");
        this.restOperations = restOperations;
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    @Override
    public OAuth2ServiceEndpointsProvider retrieveEndpoints(@Nonnull URI discoveryEndpointUri) throws OAuth2ServiceException {
        Assertions.assertNotNull(discoveryEndpointUri, "discoveryEndpointUri must not be null!");
        return this.executeRequest(discoveryEndpointUri, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0);
    }

    private OAuth2ServiceEndpointsProvider executeRequest(URI discoveryEndpointUri, int attemptsLeft) throws OAuth2ServiceException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("User-Agent", HttpClientUtil.getUserAgent());
        LOGGER.debug("Retrieving configured oidc endpoints: {} with headers {} and {} retries left", new Object[]{discoveryEndpointUri, headers, attemptsLeft});
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(discoveryEndpointUri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class);
            int statusCode = responseEntity.getStatusCode().value();
            LOGGER.debug("Received statusCode {}", (Object)statusCode);
            if (HttpStatus.OK.value() == statusCode) {
                LOGGER.debug("Successfully retrieved configured oidc endpoints from {}", (Object)discoveryEndpointUri);
                return new DefaultOidcConfigurationService.OidcEndpointsProvider((String)responseEntity.getBody());
            }
            if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                return this.executeRequest(discoveryEndpointUri, attemptsLeft - 1);
            }
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withRequestHeaders(SpringOidcConfigurationService.getHeadersAsStringArray(headers)).withResponseHeaders(SpringOidcConfigurationService.getHeadersAsStringArray(responseEntity.getHeaders())).withStatusCode(statusCode).withResponseBody((String)responseEntity.getBody()).build();
        }
        catch (HttpClientErrorException ex) {
            throw OAuth2ServiceException.builder("Error retrieving configured oidc endpoints").withUri(discoveryEndpointUri).withRequestHeaders(SpringOidcConfigurationService.getHeadersAsStringArray(headers)).withResponseBody(ex.getResponseBodyAsString()).withStatusCode(ex.getStatusCode().value()).build();
        }
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }

    private static String[] getHeadersAsStringArray(HttpHeaders headers) {
        return headers != null ? (String[])headers.entrySet().stream().map(e -> (String)e.getKey() + ": " + String.join((CharSequence)",", (Iterable)e.getValue())).toArray(String[]::new) : new String[]{};
    }
}

