/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.client.DefaultTokenClientConfiguration;
import com.sap.cloud.security.servlet.MDCHelper;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.AbstractOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

public class XsuaaOAuth2TokenService
extends AbstractOAuth2TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaOAuth2TokenService.class);
    private final RestOperations restOperations;
    private final DefaultTokenClientConfiguration config;

    public XsuaaOAuth2TokenService(@Nonnull RestOperations restOperations) {
        this(restOperations, TokenCacheConfiguration.defaultConfiguration());
    }

    public XsuaaOAuth2TokenService(@Nonnull RestOperations restOperations, @Nonnull TokenCacheConfiguration tokenCacheConfiguration) {
        super(tokenCacheConfiguration);
        Assertions.assertNotNull(restOperations, "restOperations is required");
        this.restOperations = restOperations;
        this.config = DefaultTokenClientConfiguration.getInstance();
    }

    @Override
    protected OAuth2TokenResponse requestAccessToken(@Nonnull URI tokenEndpointUri, com.sap.cloud.security.xsuaa.http.HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        Assertions.assertNotNull(tokenEndpointUri, "Token endpoint URI must not be null!");
        return this.executeRequest(tokenEndpointUri, headers, parameters, this.config.isRetryEnabled() ? this.config.getMaxRetryAttempts() : 0);
    }

    private OAuth2TokenResponse executeRequest(URI tokenEndpointUri, com.sap.cloud.security.xsuaa.http.HttpHeaders headers, Map<String, String> parameters, int attemptsLeft) throws OAuth2ServiceException {
        URI requestUri = this.createRequestUri(tokenEndpointUri);
        HttpHeaders springHeaders = this.createSpringHeaders(headers);
        HttpEntity requestEntity = new HttpEntity(this.copyIntoForm(parameters), (MultiValueMap)springHeaders);
        LOGGER.debug("Requesting access token from url='{}' with headers={} and {} retries left", new Object[]{requestUri, springHeaders, attemptsLeft});
        try {
            ResponseEntity responseEntity = this.restOperations.postForEntity(requestUri, (Object)requestEntity, Map.class);
            int statusCode = responseEntity.getStatusCode().value();
            LOGGER.debug("Received statusCode {}", (Object)statusCode);
            Map accessTokenMap = (Map)responseEntity.getBody();
            if (HttpStatus.OK.value() == statusCode && accessTokenMap != null) {
                LOGGER.debug("Successfully retrieved access token from url='{}'with params {}.", (Object)requestUri, parameters);
                return this.processResponseBody(accessTokenMap);
            }
            if (attemptsLeft > 0 && this.config.getRetryStatusCodes().contains(statusCode)) {
                LOGGER.warn("Request failed with status {} but is retryable. Retrying...", (Object)statusCode);
                this.pauseBeforeNextAttempt(this.config.getRetryDelayTime());
                return this.executeRequest(tokenEndpointUri, headers, parameters, attemptsLeft - 1);
            }
            throw OAuth2ServiceException.builder("Server error while obtaining access token from XSUAA!").withUri(requestUri).withRequestHeaders(XsuaaOAuth2TokenService.getHeadersAsStringArray(springHeaders)).withResponseHeaders(XsuaaOAuth2TokenService.getHeadersAsStringArray(requestEntity.getHeaders())).withStatusCode(statusCode).withResponseBody(accessTokenMap != null ? accessTokenMap.toString() : null).build();
        }
        catch (HttpClientErrorException clientEx) {
            throw OAuth2ServiceException.builder("Client error retrieving JWT token. Call to XSUAA was not successful!").withUri(requestUri).withRequestHeaders(XsuaaOAuth2TokenService.getHeadersAsStringArray(springHeaders)).withStatusCode(clientEx.getStatusCode().value()).withResponseBody(clientEx.getResponseBodyAsString()).build();
        }
        catch (HttpServerErrorException serverEx) {
            throw OAuth2ServiceException.builder("Server error while obtaining access token from XSUAA!").withUri(requestUri).withRequestHeaders(XsuaaOAuth2TokenService.getHeadersAsStringArray(springHeaders)).withStatusCode(serverEx.getStatusCode().value()).withResponseBody(serverEx.getResponseBodyAsString()).build();
        }
        catch (ResourceAccessException resourceEx) {
            throw OAuth2ServiceException.builder("RestClient isn't configured properly - Error while obtaining access token from XSUAA!").withUri(requestUri).withRequestHeaders(XsuaaOAuth2TokenService.getHeadersAsStringArray(springHeaders)).withResponseBody(resourceEx.getLocalizedMessage()).build();
        }
    }

    private static String[] getHeadersAsStringArray(HttpHeaders headers) {
        return headers != null ? (String[])headers.entrySet().stream().map(e -> (String)e.getKey() + ": " + String.join((CharSequence)",", (Iterable)e.getValue())).toArray(String[]::new) : new String[]{};
    }

    private MultiValueMap<String, String> copyIntoForm(Map<String, String> parameters) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((MultiValueMap)formData).add(arg_0, arg_1));
        }
        return formData;
    }

    private OAuth2TokenResponse processResponseBody(Map<String, String> accessTokenMap) throws OAuth2ServiceException {
        long expiresIn;
        String accessToken = accessTokenMap.get("access_token");
        try {
            expiresIn = Long.parseLong(String.valueOf(accessTokenMap.get("expires_in")));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Invalid expires_in value: {}", (Object)accessTokenMap.get("expires_in"), (Object)e);
            throw OAuth2ServiceException.builder("Invalid expires_in value").withResponseBody(e.getLocalizedMessage()).build();
        }
        String refreshToken = accessTokenMap.get("refresh_token");
        String tokenType = accessTokenMap.get("token_type");
        return new OAuth2TokenResponse(accessToken, expiresIn, refreshToken, tokenType);
    }

    private URI createRequestUri(URI tokenEndpointUri) {
        return UriComponentsBuilder.fromUri((URI)tokenEndpointUri).build().encode().toUri();
    }

    private HttpHeaders createSpringHeaders(com.sap.cloud.security.xsuaa.http.HttpHeaders headers) {
        HttpHeaders springHeaders = new HttpHeaders();
        headers.getHeaders().forEach(h -> springHeaders.add(h.getName(), h.getValue()));
        springHeaders.add("X-CorrelationID", MDCHelper.getOrCreateCorrelationId());
        springHeaders.add("User-Agent", HttpClientUtil.getUserAgent());
        return springHeaders;
    }

    private void pauseBeforeNextAttempt(long sleepTime) {
        try {
            LOGGER.info("Retry again in {} ms", (Object)sleepTime);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread.sleep has been interrupted. Retry starts now.");
        }
    }
}

